/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.core.app.NotificationCompat;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarEvent;
import io.radar.sdk.model.RadarGeofence;
import io.radar.sdk.model.RadarTrip;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/radar/sdk/RadarNotificationHelper;", "", "()V", "Companion", "sdk_release"})
public final class RadarNotificationHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String CHANNEL_NAME = "Location";
    private static final int NOTIFICATION_ID = 20160525;

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/radar/sdk/RadarNotificationHelper$Companion;", "", "()V", "CHANNEL_NAME", "", "NOTIFICATION_ID", "", "showNotifications", "", "context", "Landroid/content/Context;", "events", "", "Lio/radar/sdk/model/RadarEvent;", "showNotifications$sdk_release", "(Landroid/content/Context;[Lio/radar/sdk/model/RadarEvent;)V", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void showNotifications$sdk_release(@NotNull Context context, @NotNull RadarEvent[] events) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)events, (String)"events");
            if (Build.VERSION.SDK_INT < 26) {
                return;
            }
            RadarEvent[] radarEventArray = events;
            int n = 0;
            int n2 = radarEventArray.length;
            while (n < n2) {
                Object object;
                RadarEvent event = radarEventArray[n];
                ++n;
                String notificationText = null;
                if (event.getType() == RadarEvent.RadarEventType.USER_ENTERED_GEOFENCE) {
                    JSONObject jSONObject;
                    object = event.getGeofence();
                    notificationText = object == null ? null : ((jSONObject = ((RadarGeofence)object).getMetadata()) == null ? null : jSONObject.optString("radar:entryNotificationText"));
                } else if (event.getType() == RadarEvent.RadarEventType.USER_EXITED_GEOFENCE) {
                    JSONObject jSONObject;
                    object = event.getGeofence();
                    notificationText = object == null ? null : ((jSONObject = ((RadarGeofence)object).getMetadata()) == null ? null : jSONObject.optString("radar:exitNotificationText"));
                } else if (event.getType() == RadarEvent.RadarEventType.USER_ENTERED_BEACON) {
                    JSONObject jSONObject;
                    object = event.getBeacon();
                    notificationText = object == null ? null : ((jSONObject = ((RadarBeacon)object).getMetadata()) == null ? null : jSONObject.optString("radar:entryNotificationText"));
                } else if (event.getType() == RadarEvent.RadarEventType.USER_EXITED_BEACON) {
                    JSONObject jSONObject;
                    object = event.getBeacon();
                    notificationText = object == null ? null : ((jSONObject = ((RadarBeacon)object).getMetadata()) == null ? null : jSONObject.optString("radar:exitNotificationText"));
                } else if (event.getType() == RadarEvent.RadarEventType.USER_APPROACHING_TRIP_DESTINATION) {
                    JSONObject jSONObject;
                    object = event.getTrip();
                    notificationText = object == null ? null : ((jSONObject = ((RadarTrip)object).getMetadata()) == null ? null : jSONObject.optString("radar:approachingNotificationText"));
                } else if (event.getType() == RadarEvent.RadarEventType.USER_ARRIVED_AT_TRIP_DESTINATION) {
                    JSONObject jSONObject;
                    object = event.getTrip();
                    String string = object == null ? null : (notificationText = (jSONObject = ((RadarTrip)object).getMetadata()) == null ? null : jSONObject.optString("radar:arrivalNotificationText"));
                }
                if (notificationText == null) continue;
                object = notificationText;
                boolean bl = false;
                if (!(object.length() > 0)) continue;
                String id = event.get_id();
                Object object2 = context.getSystemService("notification");
                NotificationManager notificationManager = object2 instanceof NotificationManager ? (NotificationManager)object2 : null;
                int importance = 4;
                NotificationChannel channel = new NotificationChannel(RadarNotificationHelper.CHANNEL_NAME, (CharSequence)RadarNotificationHelper.CHANNEL_NAME, importance);
                channel.enableVibration(true);
                NotificationManager notificationManager2 = notificationManager;
                if (notificationManager2 != null) {
                    notificationManager2.createNotificationChannel(channel);
                }
                Notification notification = new NotificationCompat.Builder(context, RadarNotificationHelper.CHANNEL_NAME).setSmallIcon(context.getApplicationContext().getApplicationInfo().icon).setAutoCancel(true).setContentText((CharSequence)notificationText).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)notificationText)).setPriority(0).build();
                Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(context, CHANNEL_NAME)\n                        .setSmallIcon(context.applicationContext.applicationInfo.icon)\n                        .setAutoCancel(true)\n                        .setContentText(notificationText)\n                        .setStyle(NotificationCompat.BigTextStyle().bigText(notificationText))\n                        .setPriority(NotificationCompat.PRIORITY_DEFAULT)\n                        .build()");
                Notification notification2 = notification;
                notification = notificationManager;
                if (notification == null) continue;
                notification.notify(id, 20160525, notification2);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

