/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import android.content.SharedPreferences;
import io.radar.sdk.model.RadarReplay;
import io.radar.sdk.util.Flushable;
import io.radar.sdk.util.RadarReplayBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/radar/sdk/util/RadarSimpleReplayBuffer;", "Lio/radar/sdk/util/RadarReplayBuffer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "buffer", "Ljava/util/concurrent/LinkedBlockingDeque;", "Lio/radar/sdk/model/RadarReplay;", "getFlushableReplaysStash", "Lio/radar/sdk/util/Flushable;", "getSharedPreferences", "Landroid/content/SharedPreferences;", "loadFromSharedPreferences", "", "saveToSharedPreferences", "write", "replayParams", "Lorg/json/JSONObject;", "Companion", "sdk_release"})
public final class RadarSimpleReplayBuffer
implements RadarReplayBuffer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final LinkedBlockingDeque<RadarReplay> buffer;
    @Deprecated
    public static final int MAXIMUM_CAPACITY = 120;
    @Deprecated
    @NotNull
    public static final String PREFERENCES_NAME = "RadarReplayBufferPreferences";
    @Deprecated
    @NotNull
    public static final String KEY_REPLAYS = "replays";

    public RadarSimpleReplayBuffer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.buffer = new LinkedBlockingDeque(120);
    }

    @Override
    public void write(@NotNull JSONObject replayParams) {
        Intrinsics.checkNotNullParameter((Object)replayParams, (String)"replayParams");
        if (this.buffer.size() >= 120) {
            this.buffer.removeFirst();
        }
        this.buffer.offer(new RadarReplay(replayParams));
        this.saveToSharedPreferences();
    }

    @Override
    @NotNull
    public Flushable<RadarReplay> getFlushableReplaysStash() {
        List replays = CollectionsKt.toList((Iterable)this.buffer);
        return new Flushable<RadarReplay>((List<RadarReplay>)replays, this){
            final /* synthetic */ List<RadarReplay> $replays;
            final /* synthetic */ RadarSimpleReplayBuffer this$0;
            {
                this.$replays = $replays;
                this.this$0 = $receiver;
            }

            @NotNull
            public List<RadarReplay> get() {
                return this.$replays;
            }

            public void onFlush(boolean success) {
                if (success) {
                    RadarSimpleReplayBuffer.access$getBuffer$p(this.this$0).clear();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void saveToSharedPreferences() {
        Collection<JSONObject> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.buffer;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RadarReplay radarReplay = (RadarReplay)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONObject jSONObject = it.toJson();
            collection.add(jSONObject);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        JSONArray replaysAsJsonArray = new JSONArray(collection2);
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences(this.context);
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$saveToSharedPreferences_u24lambda_u2d1 = editor$iv;
        boolean bl = false;
        $this$saveToSharedPreferences_u24lambda_u2d1.putString(KEY_REPLAYS, replaysAsJsonArray.toString());
        editor$iv.apply();
    }

    @Override
    public void loadFromSharedPreferences() {
        String replaysAsString = this.getSharedPreferences(this.context).getString(KEY_REPLAYS, null);
        String string = replaysAsString;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String replays = string2;
            boolean bl3 = false;
            int n = 0;
            JSONArray replaysAsJsonArray = new JSONArray(replays);
            int n2 = replaysAsJsonArray.length();
            if (n < n2) {
                do {
                    int i = n++;
                    JSONObject replayAsJsonObject = replaysAsJsonArray.getJSONObject(i);
                    Intrinsics.checkNotNullExpressionValue((Object)replayAsJsonObject, (String)"replayAsJsonObject");
                    RadarReplay replay = RadarReplay.Companion.fromJson(replayAsJsonObject);
                    this.buffer.offer(replay);
                } while (n < n2);
            }
        }
    }

    private final SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFERENCES_NAME, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPreferences(PREFERENCES_NAME, Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    public static final /* synthetic */ LinkedBlockingDeque access$getBuffer$p(RadarSimpleReplayBuffer $this) {
        return $this.buffer;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/radar/sdk/util/RadarSimpleReplayBuffer$Companion;", "", "()V", "KEY_REPLAYS", "", "MAXIMUM_CAPACITY", "", "PREFERENCES_NAME", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

