/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\t\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/radar/sdk/RadarForegroundService;", "Landroid/app/Service;", "()V", "logger", "Lio/radar/sdk/RadarLogger;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onStartCommand", "", "flags", "startId", "startForegroundService", "", "extras", "Landroid/os/Bundle;", "Companion", "sdk_release"})
@RequiresApi(value=26)
public final class RadarForegroundService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private RadarLogger logger;
    private static boolean started;
    private static final int NOTIFICATION_ID = 20160525;

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (this.logger == null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            this.logger = new RadarLogger(context);
        }
        if (intent != null) {
            if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"start")) {
                try {
                    this.startForegroundService(intent.getExtras());
                }
                catch (Exception e) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        throw null;
                    }
                    radarLogger.e("Error starting foreground service", Radar.RadarLogType.SDK_EXCEPTION, e);
                }
            } else if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"stop")) {
                try {
                    this.stopForeground(true);
                    this.stopSelf();
                }
                catch (Exception e) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        throw null;
                    }
                    radarLogger.e("Error stopping foreground service", Radar.RadarLogType.SDK_EXCEPTION, e);
                }
            }
        }
        return 1;
    }

    private final void startForegroundService(Bundle extras) {
        boolean bl;
        Object object;
        Bundle bundle;
        String string;
        int n;
        String string2;
        String string3;
        int n2;
        int n3;
        Object object2 = this.getSystemService("notification");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager manager = (NotificationManager)object2;
        manager.deleteNotificationChannel("RadarSDK");
        Bundle bundle2 = extras;
        int id = bundle2 == null ? 0 : (n3 = bundle2.getInt("id"));
        id = id == 0 ? 20160525 : id;
        Bundle bundle3 = extras;
        int importance = bundle3 == null ? 0 : (n2 = bundle3.getInt("importance"));
        importance = importance == 0 ? 3 : importance;
        Bundle bundle4 = extras;
        String title = bundle4 == null ? null : bundle4.getString("title");
        Bundle bundle5 = extras;
        String text = string3 = bundle5 == null ? "Location tracking started" : ((string2 = bundle5.getString("text")) == null ? "Location tracking started" : string2);
        bundle5 = extras;
        int icon = bundle5 == null ? 0 : (n = bundle5.getInt("icon"));
        Bundle bundle6 = extras;
        String string4 = bundle6 == null ? null : bundle6.getString("iconString");
        string2 = string4 == null ? String.valueOf(this.getApplicationInfo().icon) : string4;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"extras?.getString(\"iconString\") ?: this.applicationInfo.icon.toString()");
        String iconString = string2;
        bundle6 = extras;
        String iconColor = string4 = bundle6 == null ? "" : ((string = bundle6.getString("iconColor")) == null ? "" : string);
        int smallIcon = this.getResources().getIdentifier(iconString, "drawable", this.getApplicationContext().getPackageName());
        if (icon != 0) {
            smallIcon = this.getResources().getIdentifier(String.valueOf(icon), "drawable", this.getApplicationContext().getPackageName());
        }
        String channelName = string = (bundle = extras) == null ? "Location Services" : ((object = bundle.getString("channelName")) == null ? "Location Services" : object);
        NotificationChannel channel = new NotificationChannel("RadarSDK", (CharSequence)channelName, importance);
        object = this.getSystemService("notification");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object;
        notificationManager.createNotificationChannel(channel);
        Object builder = null;
        Object object3 = new Notification.Builder(this.getApplicationContext(), "RadarSDK").setContentText((CharSequence)text).setOngoing(true).setSmallIcon(smallIcon);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"Builder(applicationContext, \"RadarSDK\")\n            .setContentText(text as CharSequence?)\n            .setOngoing(true)\n            .setSmallIcon(smallIcon)");
        builder = object3;
        if (title != null) {
            object3 = title;
            bl = false;
            if (object3.length() > 0) {
                object3 = builder.setContentTitle((CharSequence)title);
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"builder.setContentTitle(title as CharSequence?)");
                builder = object3;
            }
        }
        object3 = iconColor;
        bl = false;
        if (object3.length() > 0) {
            builder.setColor(Color.parseColor((String)iconColor));
        }
        try {
            String string5;
            object3 = extras;
            if (object3 != null && (string5 = object3.getString("activity")) != null) {
                String string6 = string5;
                boolean bl2 = false;
                boolean bl3 = false;
                String it = string6;
                boolean bl4 = false;
                Class<?> activityClass = Class.forName(it);
                Intent intent = new Intent((Context)this, activityClass);
                intent.setFlags(0x10008000);
                int flags = 0x4000000;
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)((Context)this), (int)0, (Intent)intent, (int)flags);
                Notification.Builder builder2 = builder.setContentIntent(pendingIntent);
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"builder.setContentIntent(pendingIntent)");
                builder = builder2;
            }
        }
        catch (ClassNotFoundException e) {
            RadarLogger radarLogger = this.logger;
            if (radarLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                throw null;
            }
            radarLogger.e("Error setting foreground service content intent", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        Notification notification = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
        Notification notification2 = notification;
        this.startForeground(id, notification2);
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/radar/sdk/RadarForegroundService$Companion;", "", "()V", "NOTIFICATION_ID", "", "started", "", "getStarted$sdk_release", "()Z", "setStarted$sdk_release", "(Z)V", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getStarted$sdk_release() {
            return started;
        }

        public final void setStarted$sdk_release(boolean bl) {
            started = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

