/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.location.Location;
import com.google.android.gms.tasks.Task;
import com.google.android.play.core.integrity.IntegrityManagerFactory;
import com.google.android.play.core.integrity.StandardIntegrityManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.RadarUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JS\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2:\u0010\u000f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0010H\u0000\u00a2\u0006\u0002\b\u0015J[\u0010\u0016\u001a\u00020\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2:\u0010\u000f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0010\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ[\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2:\u0010\u000f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0015\u0012\u0013\u0018\u00010\u000e\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\f0\u0010H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/radar/sdk/RadarVerificationManager;", "", "context", "Landroid/content/Context;", "logger", "Lio/radar/sdk/RadarLogger;", "(Landroid/content/Context;Lio/radar/sdk/RadarLogger;)V", "lastWarmUpTimestampSeconds", "", "standardIntegrityTokenProvider", "Lcom/google/android/play/core/integrity/StandardIntegrityManager$StandardIntegrityTokenProvider;", "fetchTokenFromGoogle", "", "requestHash", "", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "integrityToken", "integrityException", "fetchTokenFromGoogle$sdk_release", "getIntegrityToken", "googlePlayProjectNumber", "(Ljava/lang/Long;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getRequestHash", "location", "Landroid/location/Location;", "warmupProviderAndFetchTokenFromGoogle", "warmupProviderAndFetchTokenFromGoogle$sdk_release", "Companion", "sdk_release"})
public final class RadarVerificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final RadarLogger logger;
    private StandardIntegrityManager.StandardIntegrityTokenProvider standardIntegrityTokenProvider;
    private long lastWarmUpTimestampSeconds;
    private static final int WARM_UP_WINDOW_SECONDS = 43200;

    public RadarVerificationManager(@NotNull Context context, @NotNull RadarLogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.logger = logger;
    }

    @NotNull
    public final String getRequestHash(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(RadarSettings.INSTANCE.getInstallId$sdk_release(this.context));
        stringBuffer.append(location.getLatitude());
        stringBuffer.append(location.getLongitude());
        stringBuffer.append(location.isFromMockProvider());
        stringBuffer.append(RadarUtils.INSTANCE.isScreenSharing$sdk_release(this.context));
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuffer.toString()");
        return RadarUtils.INSTANCE.hashSHA256(string);
    }

    public final void warmupProviderAndFetchTokenFromGoogle$sdk_release(long googlePlayProjectNumber, @Nullable String requestHash, @NotNull Function2<? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        StandardIntegrityManager standardIntegrityManager = IntegrityManagerFactory.createStandard((Context)this.context);
        Intrinsics.checkNotNullExpressionValue((Object)standardIntegrityManager, (String)"createStandard(this.context)");
        StandardIntegrityManager standardIntegrityManager2 = standardIntegrityManager;
        standardIntegrityManager2.prepareIntegrityToken(StandardIntegrityManager.PrepareIntegrityTokenRequest.builder().setCloudProjectNumber(googlePlayProjectNumber).build()).addOnSuccessListener(arg_0 -> RadarVerificationManager.warmupProviderAndFetchTokenFromGoogle$lambda-0(this, requestHash, block, arg_0)).addOnFailureListener(arg_0 -> RadarVerificationManager.warmupProviderAndFetchTokenFromGoogle$lambda-1(block, arg_0));
    }

    public final void getIntegrityToken(@Nullable Long googlePlayProjectNumber, @Nullable String requestHash, @NotNull Function2<? super String, ? super String, Unit> block) {
        boolean warmUpProvider;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (requestHash == null) {
            String integrityException = "Missing request hash";
            RadarLogger.d$default(this.logger, integrityException, null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        if (googlePlayProjectNumber == null) {
            String integrityException = "Google Play project number is null";
            RadarLogger.d$default(this.logger, "Error warming up integrity token provider: Google Play project number is null", null, null, 6, null);
            block.invoke(null, (Object)integrityException);
            return;
        }
        long nowSeconds = System.currentTimeMillis() / (long)1000;
        boolean bl = warmUpProvider = this.standardIntegrityTokenProvider == null || this.lastWarmUpTimestampSeconds == 0L || nowSeconds - this.lastWarmUpTimestampSeconds > 43200L;
        if (warmUpProvider) {
            this.warmupProviderAndFetchTokenFromGoogle$sdk_release(googlePlayProjectNumber, requestHash, block);
            return;
        }
        this.fetchTokenFromGoogle$sdk_release(requestHash, block);
    }

    public final void fetchTokenFromGoogle$sdk_release(@Nullable String requestHash, @NotNull Function2<? super String, ? super String, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        RadarLogger.d$default(this.logger, "Requesting integrity token", null, null, 6, null);
        StandardIntegrityManager.StandardIntegrityTokenProvider standardIntegrityTokenProvider = this.standardIntegrityTokenProvider;
        if (standardIntegrityTokenProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"standardIntegrityTokenProvider");
            throw null;
        }
        Task task = standardIntegrityTokenProvider.request(StandardIntegrityManager.StandardIntegrityTokenRequest.builder().setRequestHash(requestHash).build());
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"this.standardIntegrityTokenProvider.request(\n            StandardIntegrityTokenRequest.builder()\n                .setRequestHash(requestHash)\n                .build()\n        )");
        Task integrityTokenResponse = task;
        integrityTokenResponse.addOnSuccessListener(arg_0 -> RadarVerificationManager.fetchTokenFromGoogle$lambda-2(this, block, arg_0)).addOnFailureListener(arg_0 -> RadarVerificationManager.fetchTokenFromGoogle$lambda-3(this, block, arg_0));
    }

    private static final void warmupProviderAndFetchTokenFromGoogle$lambda-0(RadarVerificationManager this$0, String $requestHash, Function2 $block, StandardIntegrityManager.StandardIntegrityTokenProvider tokenProvider) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)tokenProvider, (String)"tokenProvider");
        this$0.standardIntegrityTokenProvider = tokenProvider;
        RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "successful warm up of the integrity token provider", null, null, 6, null);
        this$0.lastWarmUpTimestampSeconds = System.currentTimeMillis() / (long)1000;
        this$0.fetchTokenFromGoogle$sdk_release($requestHash, (Function2<? super String, ? super String, Unit>)$block);
    }

    private static final void warmupProviderAndFetchTokenFromGoogle$lambda-1(Function2 $block, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Exception exception2 = exception;
        String warmupException = exception2.getMessage();
        Radar.INSTANCE.getLogger$sdk_release().e(Intrinsics.stringPlus((String)"Error warming up integrity token provider | warmupException = ", (Object)warmupException), Radar.RadarLogType.SDK_ERROR, exception);
        $block.invoke(null, (Object)warmupException);
    }

    private static final void fetchTokenFromGoogle$lambda-2(RadarVerificationManager this$0, Function2 $block, StandardIntegrityManager.StandardIntegrityToken response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        String integrityToken = response.token();
        RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Successfully requested integrity token | integrityToken = ", (Object)integrityToken), null, null, 6, null);
        $block.invoke((Object)integrityToken, null);
    }

    private static final void fetchTokenFromGoogle$lambda-3(RadarVerificationManager this$0, Function2 $block, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Exception exception2 = exception;
        String integrityException = exception2.getMessage();
        RadarLogger.d$default(this$0.logger, Intrinsics.stringPlus((String)"Error requesting integrity token | integrityException = ", (Object)integrityException), null, null, 6, null);
        $block.invoke(null, (Object)integrityException);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/radar/sdk/RadarVerificationManager$Companion;", "", "()V", "WARM_UP_WINDOW_SECONDS", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

