/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk.util;

import android.content.Context;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ3\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\b2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0010j\b\u0012\u0004\u0012\u00020\r`\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/radar/sdk/util/RadarFileStorage;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deleteFileAtPath", "", "subDir", "", "filePath", "readFileAtPath", "sortedFilesInDirectory", "", "Ljava/io/File;", "directoryPath", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/lang/String;Ljava/util/Comparator;)[Ljava/io/File;", "writeData", "", "filename", "content", "sdk_release"})
public final class RadarFileStorage {
    @NotNull
    private final Context context;

    public RadarFileStorage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeData(@NotNull String subDir, @NotNull String filename, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)subDir, (String)"subDir");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        FileOutputStream fileOutputStream = null;
        try {
            CharSequence charSequence = subDir;
            boolean bl = false;
            File directory = charSequence.length() > 0 ? new File(this.context.getFilesDir(), subDir) : this.context.getFilesDir();
            directory.mkdirs();
            File file = new File(directory, filename);
            fileOutputStream = new FileOutputStream(file);
            Closeable closeable = fileOutputStream;
            boolean bl2 = false;
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                FileOutputStream it = (FileOutputStream)closeable;
                boolean bl4 = false;
                String string = content;
                Charset charset = Charsets.UTF_8;
                boolean bl5 = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                it.write(byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static /* synthetic */ void writeData$default(RadarFileStorage radarFileStorage, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        radarFileStorage.writeData(string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public final String readFileAtPath(@NotNull String subDir, @NotNull String filePath) {
        block8: {
            Object object;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)subDir, (String)"subDir");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            FileInputStream fileInputStream = null;
            try {
                CharSequence charSequence = subDir;
                boolean bl = false;
                File directory = charSequence.length() > 0 ? new File(this.context.getFilesDir(), subDir) : this.context.getFilesDir();
                File file = new File(directory, filePath);
                fileInputStream = new FileInputStream(file);
                object2 = fileInputStream;
                object = (InputStream)object2;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, charset);
                object2 = inputStreamReader;
                object = TextStreamsKt.readText((Reader)((Reader)object2));
                object2 = object == null ? "" : object;
                object = fileInputStream;
            }
            catch (FileNotFoundException e) {
                String string = "";
                return string;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileInputStream fileInputStream2 = fileInputStream;
                if (fileInputStream2 != null) {
                    fileInputStream2.close();
                }
            }
            ((FileInputStream)object).close();
            return object2;
        }
        return "";
    }

    public static /* synthetic */ String readFileAtPath$default(RadarFileStorage radarFileStorage, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return radarFileStorage.readFileAtPath(string, string2);
    }

    public final boolean deleteFileAtPath(@NotNull String subDir, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)subDir, (String)"subDir");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            CharSequence charSequence = subDir;
            boolean bl = false;
            File directory = charSequence.length() > 0 ? new File(this.context.getFilesDir(), subDir) : this.context.getFilesDir();
            File file = new File(directory, filePath);
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static /* synthetic */ boolean deleteFileAtPath$default(RadarFileStorage radarFileStorage, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return radarFileStorage.deleteFileAtPath(string, string2);
    }

    @Nullable
    public final File[] sortedFilesInDirectory(@NotNull String directoryPath, @NotNull Comparator<File> comparator) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        try {
            Object[] files;
            File directory = new File(this.context.getFilesDir(), directoryPath);
            Object[] objectArray = files = directory.listFiles();
            if (objectArray != null) {
                ArraysKt.sortWith((Object[])objectArray, comparator);
            }
            return files;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

