/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017J\"\u0010\u000b\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/radar/sdk/RadarForegroundService;", "Landroid/app/Service;", "()V", "logger", "Lio/radar/sdk/RadarLogger;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onDestroy", "", "onStartCommand", "", "flags", "startId", "startForegroundService", "extras", "Landroid/os/Bundle;", "Companion", "sdk_release"})
@RequiresApi(value=26)
public final class RadarForegroundService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private RadarLogger logger;
    private static boolean started;
    private static final int NOTIFICATION_ID = 20160525;

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        if (this.logger == null) {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            this.logger = new RadarLogger(context);
        }
        if (intent != null) {
            if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"start")) {
                try {
                    this.startForegroundService(intent.getExtras());
                }
                catch (Exception e) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        radarLogger = null;
                    }
                    radarLogger.e("Error starting foreground service", Radar.RadarLogType.SDK_EXCEPTION, e);
                }
            } else if (Intrinsics.areEqual((Object)intent.getAction(), (Object)"stop")) {
                try {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        radarLogger = null;
                    }
                    RadarLogger.d$default(radarLogger, "Stopping foreground service", null, null, 6, null);
                    this.stopForeground(true);
                    this.stopSelf();
                }
                catch (Exception e) {
                    RadarLogger radarLogger = this.logger;
                    if (radarLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        radarLogger = null;
                    }
                    radarLogger.e("Error stopping foreground service", Radar.RadarLogType.SDK_EXCEPTION, e);
                }
            }
        }
        return 1;
    }

    @SuppressLint(value={"DiscouragedApi"})
    public void onDestroy() {
        super.onDestroy();
        started = false;
        RadarLogger radarLogger = this.logger;
        if (radarLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            radarLogger = null;
        }
        RadarLogger.d$default(radarLogger, "Foreground service destroyed", null, null, 6, null);
    }

    private final void startForegroundService(Bundle extras) {
        Object object;
        Object object2 = this.getSystemService("notification");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager manager = (NotificationManager)object2;
        manager.deleteNotificationChannel("RadarSDK");
        Bundle bundle = extras;
        int id = bundle != null ? bundle.getInt("id") : 0;
        id = id == 0 ? 20160525 : id;
        Bundle bundle2 = extras;
        int importance = bundle2 != null ? bundle2.getInt("importance") : 0;
        importance = importance == 0 ? 3 : importance;
        Bundle bundle3 = extras;
        String title = bundle3 != null ? bundle3.getString("title") : null;
        Object object3 = extras;
        if (object3 == null || (object3 = object3.getString("text")) == null) {
            object3 = "Location tracking started";
        }
        Object text = object3;
        Bundle bundle4 = extras;
        int icon = bundle4 != null ? bundle4.getInt("icon") : 0;
        Object object4 = extras;
        if (object4 == null || (object4 = object4.getString("iconString")) == null) {
            object4 = String.valueOf(this.getApplicationInfo().icon);
        }
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"extras?.getString(\"iconS\u2026ationInfo.icon.toString()");
        Object iconString = object4;
        Object object5 = extras;
        if (object5 == null || (object5 = object5.getString("iconColor")) == null) {
            object5 = "";
        }
        Object iconColor = object5;
        int smallIcon = this.getResources().getIdentifier((String)iconString, "drawable", this.getApplicationContext().getPackageName());
        if (icon != 0) {
            smallIcon = this.getResources().getIdentifier(String.valueOf(icon), "drawable", this.getApplicationContext().getPackageName());
        }
        if ((object = extras) == null || (object = object.getString("channelName")) == null) {
            object = "Location Services";
        }
        Object channelName = object;
        NotificationChannel channel = new NotificationChannel("RadarSDK", (CharSequence)channelName, importance);
        Object object6 = this.getSystemService("notification");
        if (object6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.app.NotificationManager");
        }
        NotificationManager notificationManager = (NotificationManager)object6;
        notificationManager.createNotificationChannel(channel);
        Notification.Builder builder = null;
        Notification.Builder builder2 = new Notification.Builder(this.getApplicationContext(), "RadarSDK").setContentText((CharSequence)text).setOngoing(true).setSmallIcon(smallIcon);
        Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"Builder(applicationConte\u2026 .setSmallIcon(smallIcon)");
        builder = builder2;
        if (title != null && ((CharSequence)title).length() > 0) {
            Notification.Builder builder3 = builder.setContentTitle((CharSequence)title);
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"builder.setContentTitle(title as CharSequence?)");
            builder = builder3;
        }
        if (((CharSequence)iconColor).length() > 0) {
            builder.setColor(Color.parseColor((String)iconColor));
        }
        try {
            Object object7 = extras;
            if (object7 != null && (object7 = object7.getString("activity")) != null) {
                Object it = object7;
                boolean bl = false;
                Class<?> activityClass = Class.forName((String)it);
                Intent intent = new Intent((Context)this, activityClass);
                intent.setFlags(0x10008000);
                int flags = Build.VERSION.SDK_INT >= 23 ? 0x4000000 : 0;
                PendingIntent pendingIntent = PendingIntent.getActivity((Context)((Context)this), (int)0, (Intent)intent, (int)flags);
                Notification.Builder builder4 = builder.setContentIntent(pendingIntent);
                Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"builder.setContentIntent(pendingIntent)");
                builder = builder4;
            }
        }
        catch (ClassNotFoundException e) {
            RadarLogger radarLogger = this.logger;
            if (radarLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                radarLogger = null;
            }
            radarLogger.e("Error setting foreground service content intent", Radar.RadarLogType.SDK_EXCEPTION, e);
        }
        Notification notification = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
        Notification notification2 = notification;
        if (Build.VERSION.SDK_INT >= 34) {
            this.startForeground(id, notification2, 8);
        } else {
            this.startForeground(id, notification2);
        }
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/radar/sdk/RadarForegroundService$Companion;", "", "()V", "NOTIFICATION_ID", "", "started", "", "getStarted$sdk_release", "()Z", "setStarted$sdk_release", "(Z)V", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getStarted$sdk_release() {
            return started;
        }

        public final void setStarted$sdk_release(boolean bl) {
            started = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

