/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.PersistableBundle;
import androidx.annotation.RequiresApi;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarBeaconUtils;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarSettings;
import io.radar.sdk.model.RadarBeacon;
import io.radar.sdk.model.RadarFeatureSettings;
import io.radar.sdk.util.BatteryState;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lio/radar/sdk/RadarJobScheduler;", "Landroid/app/job/JobService;", "()V", "onStartJob", "", "params", "Landroid/app/job/JobParameters;", "onStopJob", "Companion", "sdk_release"})
@RequiresApi(value=21)
public final class RadarJobScheduler
extends JobService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTRA_LATITUDE = "latitude";
    @NotNull
    private static final String EXTRA_LONGITUDE = "longitude";
    @NotNull
    private static final String EXTRA_ACCURACY = "accuracy";
    @NotNull
    private static final String EXTRA_PROVIDER = "provider";
    @NotNull
    private static final String EXTRA_TIME = "time";
    @NotNull
    private static final String EXTRA_SOURCE = "source";
    @NotNull
    private static final String EXTRA_BEACONS = "beacons";
    @NotNull
    private static final String EXTRA_ONLY_REPLAYING = "onlyReplaying";
    private static final int BASE_JOB_ID_LOCATIONS = 20160525;
    private static final int BASE_JOB_ID_BEACONS = 20210216;
    @NotNull
    private static final AtomicInteger numActiveLocationJobs = new AtomicInteger();
    @NotNull
    private static final AtomicInteger numActiveBeaconJobs = new AtomicInteger();

    public boolean onStartJob(@NotNull JobParameters params) {
        Location location;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!Radar.INSTANCE.getInitialized$sdk_release()) {
            Radar.initialize$default(this.getApplicationContext(), null, 2, null);
        }
        PersistableBundle persistableBundle = params.getExtras();
        Intrinsics.checkNotNullExpressionValue((Object)persistableBundle, (String)"params.extras");
        PersistableBundle extras = persistableBundle;
        Object[] beaconsArr = extras.getStringArray(EXTRA_BEACONS);
        double latitude = extras.getDouble(EXTRA_LATITUDE);
        double longitude = extras.getDouble(EXTRA_LONGITUDE);
        float accuracy = (float)extras.getDouble(EXTRA_ACCURACY);
        String provider = extras.getString(EXTRA_PROVIDER);
        long time = extras.getLong(EXTRA_TIME);
        boolean onlyReplaying = Intrinsics.areEqual((Object)extras.getString(EXTRA_ONLY_REPLAYING), (Object)"true");
        if (onlyReplaying) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Starting onlyReplaying job", null, null, 6, null);
            Radar.flushReplays$sdk_release$default(null, null, 3, null);
            new Handler(Looper.getMainLooper()).postDelayed(() -> RadarJobScheduler.onStartJob$lambda-0(this, params), 10000L);
            return true;
        }
        String string = extras.getString(EXTRA_SOURCE);
        if (string == null) {
            return false;
        }
        String sourceStr = string;
        Radar.RadarLocationSource source = Radar.RadarLocationSource.valueOf(sourceStr);
        if (beaconsArr != null) {
            RadarBeacon[] beacons = RadarBeaconUtils.INSTANCE.beaconsForStringArray((String[])beaconsArr);
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Starting beacons job | source = " + sourceStr + "; beaconsArr = " + ArraysKt.joinToString$default((Object[])beaconsArr, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, null, 6, null);
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.applicationContext");
            Radar.INSTANCE.handleBeacons$sdk_release(context, beacons, source);
            new Handler(Looper.getMainLooper()).postDelayed(() -> RadarJobScheduler.onStartJob$lambda-1(this, params), 10000L);
            numActiveBeaconJobs.set(0);
            return true;
        }
        Location $this$onStartJob_u24lambda_u2d2 = location = new Location(provider);
        boolean bl = false;
        $this$onStartJob_u24lambda_u2d2.setLatitude(latitude);
        $this$onStartJob_u24lambda_u2d2.setLongitude(longitude);
        $this$onStartJob_u24lambda_u2d2.setAccuracy(accuracy);
        $this$onStartJob_u24lambda_u2d2.setTime(time);
        Location location2 = location;
        if (Radar.isTestKey$sdk_release()) {
            BatteryState batteryState = Radar.INSTANCE.getBatteryManager$sdk_release().getBatteryState();
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Starting location job | source = " + sourceStr + "; location = " + location2 + "; standbyBucket = " + Radar.INSTANCE.getBatteryManager$sdk_release().getAppStandbyBucket() + "; performanceState = " + batteryState.getPerformanceState().name() + "; isCharging = " + batteryState.isCharging() + "; batteryPercentage = " + batteryState.getPercent() + "; isPowerSaveMode = " + batteryState.getPowerSaveMode() + "; isIgnoringBatteryOptimizations = " + batteryState.isIgnoringBatteryOptimizations() + "; locationPowerSaveMode = " + batteryState.getPowerLocationPowerSaveModeString() + "; isDozeMode = " + batteryState.isDeviceIdleMode(), null, null, 6, null);
        } else {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Starting location job | source = " + sourceStr + "; location = " + location2, null, null, 6, null);
        }
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.applicationContext");
        Radar.handleLocation$sdk_release$default(Radar.INSTANCE, context, location2, source, false, 8, null);
        new Handler(Looper.getMainLooper()).postDelayed(() -> RadarJobScheduler.onStartJob$lambda-3(this, params), 10000L);
        numActiveLocationJobs.set(0);
        return true;
    }

    public boolean onStopJob(@NotNull JobParameters params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!Radar.INSTANCE.getInitialized$sdk_release()) {
            Radar.initialize$default(this.getApplicationContext(), null, 2, null);
        }
        PersistableBundle persistableBundle = params.getExtras();
        Intrinsics.checkNotNullExpressionValue((Object)persistableBundle, (String)"params.extras");
        PersistableBundle extras = persistableBundle;
        Object[] beaconsArr = extras.getStringArray(EXTRA_BEACONS);
        double latitude = extras.getDouble(EXTRA_LATITUDE);
        double longitude = extras.getDouble(EXTRA_LONGITUDE);
        float accuracy = (float)extras.getDouble(EXTRA_ACCURACY);
        String provider = extras.getString(EXTRA_PROVIDER);
        long time = extras.getLong(EXTRA_TIME);
        String source = extras.getString(EXTRA_SOURCE);
        if (beaconsArr != null) {
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Stopping beacons job | source = " + source + "; beaconsArr = " + ArraysKt.joinToString$default((Object[])beaconsArr, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, null, 6, null);
        } else {
            Location location;
            Location $this$onStopJob_u24lambda_u2d4 = location = new Location(provider);
            boolean bl = false;
            $this$onStopJob_u24lambda_u2d4.setLatitude(latitude);
            $this$onStopJob_u24lambda_u2d4.setLongitude(longitude);
            $this$onStopJob_u24lambda_u2d4.setAccuracy(accuracy);
            $this$onStopJob_u24lambda_u2d4.setTime(time);
            Location location2 = location;
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Stopping location job | source = " + source + "; location = " + location2, null, null, 6, null);
        }
        return false;
    }

    private static final void onStartJob$lambda-0(RadarJobScheduler this$0, JobParameters $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        this$0.jobFinished($params, false);
    }

    private static final void onStartJob$lambda-1(RadarJobScheduler this$0, JobParameters $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        this$0.jobFinished($params, false);
    }

    private static final void onStartJob$lambda-3(RadarJobScheduler this$0, JobParameters $params) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$params, (String)"$params");
        this$0.jobFinished($params, false);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017J%\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ-\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010!J\u001d\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/radar/sdk/RadarJobScheduler$Companion;", "", "()V", "BASE_JOB_ID_BEACONS", "", "BASE_JOB_ID_LOCATIONS", "EXTRA_ACCURACY", "", "EXTRA_BEACONS", "EXTRA_LATITUDE", "EXTRA_LONGITUDE", "EXTRA_ONLY_REPLAYING", "EXTRA_PROVIDER", "EXTRA_SOURCE", "EXTRA_TIME", "numActiveBeaconJobs", "Ljava/util/concurrent/atomic/AtomicInteger;", "numActiveLocationJobs", "cancelJob", "", "context", "Landroid/content/Context;", "jobId", "cancelJob$sdk_release", "scheduleJob", "location", "Landroid/location/Location;", "source", "Lio/radar/sdk/Radar$RadarLocationSource;", "scheduleJob$sdk_release", "beacons", "", "Lio/radar/sdk/model/RadarBeacon;", "(Landroid/content/Context;[Lio/radar/sdk/model/RadarBeacon;Lio/radar/sdk/Radar$RadarLocationSource;)I", "onlyReplaying", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int scheduleJob$sdk_release(@NotNull Context context, @NotNull Location location, @NotNull Radar.RadarLocationSource source) {
            PersistableBundle persistableBundle;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)RadarJobScheduler.EXTRA_SOURCE);
            if (!Radar.INSTANCE.getInitialized$sdk_release()) {
                Radar.initialize$default(context, null, 2, null);
            }
            ComponentName componentName = new ComponentName(context, RadarJobScheduler.class);
            PersistableBundle $this$scheduleJob_u24lambda_u2d0 = persistableBundle = new PersistableBundle();
            boolean bl = false;
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_LATITUDE, location.getLatitude());
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_LONGITUDE, location.getLongitude());
            $this$scheduleJob_u24lambda_u2d0.putDouble(RadarJobScheduler.EXTRA_ACCURACY, (double)location.getAccuracy());
            $this$scheduleJob_u24lambda_u2d0.putString(RadarJobScheduler.EXTRA_PROVIDER, location.getProvider());
            $this$scheduleJob_u24lambda_u2d0.putLong(RadarJobScheduler.EXTRA_TIME, location.getTime());
            $this$scheduleJob_u24lambda_u2d0.putString(RadarJobScheduler.EXTRA_SOURCE, source.name());
            PersistableBundle extras = persistableBundle;
            String sourceStr = Radar.stringForSource(source);
            RadarFeatureSettings settings = RadarSettings.INSTANCE.getFeatureSettings(context);
            int jobId = 20160525 + numActiveLocationJobs.incrementAndGet() % settings.getMaxConcurrentJobs();
            JobInfo jobInfo = new JobInfo.Builder(jobId, componentName).setExtras(extras).setMinimumLatency(0L).setOverrideDeadline(0L).setRequiredNetworkType(settings.getSchedulerRequiresNetwork() ? 1 : 0).build();
            Object object = context.getSystemService("jobscheduler");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
            }
            JobScheduler jobScheduler = (JobScheduler)object;
            int result = jobScheduler.schedule(jobInfo);
            if (result == 1) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Scheduling location job | source = " + sourceStr + "; location = " + location, null, null, 6, null);
                return jobId;
            }
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Failed to schedule location job | source = " + sourceStr + "; location = " + location, null, null, 6, null);
            return -1;
        }

        public final int scheduleJob$sdk_release(@NotNull Context context, boolean onlyReplaying) {
            PersistableBundle persistableBundle;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!Radar.INSTANCE.getInitialized$sdk_release()) {
                Radar.initialize$default(context, null, 2, null);
            }
            ComponentName componentName = new ComponentName(context, RadarJobScheduler.class);
            PersistableBundle $this$scheduleJob_u24lambda_u2d1 = persistableBundle = new PersistableBundle();
            boolean bl = false;
            $this$scheduleJob_u24lambda_u2d1.putString(RadarJobScheduler.EXTRA_ONLY_REPLAYING, "true");
            PersistableBundle extras = persistableBundle;
            RadarFeatureSettings settings = RadarSettings.INSTANCE.getFeatureSettings(context);
            int jobId = 21160524;
            JobInfo jobInfo = new JobInfo.Builder(jobId, componentName).setExtras(extras).setMinimumLatency(0L).setOverrideDeadline(0L).setRequiredNetworkType(settings.getSchedulerRequiresNetwork() ? 1 : 0).build();
            Object object = context.getSystemService("jobscheduler");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
            }
            JobScheduler jobScheduler = (JobScheduler)object;
            int result = jobScheduler.schedule(jobInfo);
            if (result == 1) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Scheduling replaying job | onlyReplaying = " + onlyReplaying, null, null, 6, null);
                return jobId;
            }
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Failed to schedule location job | onlyReplaying = " + onlyReplaying, null, null, 6, null);
            return -1;
        }

        public final void cancelJob$sdk_release(@NotNull Context context, int jobId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getSystemService("jobscheduler");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
            }
            JobScheduler jobScheduler = (JobScheduler)object;
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Cancelling job | jobId = " + jobId, null, null, 6, null);
            jobScheduler.cancel(jobId);
        }

        public final int scheduleJob$sdk_release(@NotNull Context context, @NotNull RadarBeacon[] beacons, @NotNull Radar.RadarLocationSource source) {
            PersistableBundle persistableBundle;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)beacons, (String)RadarJobScheduler.EXTRA_BEACONS);
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)RadarJobScheduler.EXTRA_SOURCE);
            if (!Radar.INSTANCE.getInitialized$sdk_release()) {
                Radar.initialize$default(context, null, 2, null);
            }
            ComponentName componentName = new ComponentName(context, RadarJobScheduler.class);
            Object[] beaconsArr = RadarBeaconUtils.INSTANCE.stringArrayForBeacons(beacons);
            PersistableBundle $this$scheduleJob_u24lambda_u2d2 = persistableBundle = new PersistableBundle();
            boolean bl = false;
            $this$scheduleJob_u24lambda_u2d2.putStringArray(RadarJobScheduler.EXTRA_BEACONS, (String[])beaconsArr);
            $this$scheduleJob_u24lambda_u2d2.putString(RadarJobScheduler.EXTRA_SOURCE, source.name());
            PersistableBundle extras = persistableBundle;
            String sourceStr = Radar.stringForSource(source);
            RadarFeatureSettings settings = RadarSettings.INSTANCE.getFeatureSettings(context);
            int jobId = 20210216 + numActiveBeaconJobs.incrementAndGet() % settings.getMaxConcurrentJobs();
            JobInfo jobInfo = new JobInfo.Builder(jobId, componentName).setExtras(extras).setMinimumLatency(0L).setOverrideDeadline(0L).setRequiredNetworkType(settings.getSchedulerRequiresNetwork() ? 1 : 0).build();
            Object object = context.getSystemService("jobscheduler");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.job.JobScheduler");
            }
            JobScheduler jobScheduler = (JobScheduler)object;
            int result = jobScheduler.schedule(jobInfo);
            if (result == 1) {
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Scheduling beacons job | source = " + sourceStr + "; beaconsArr = " + ArraysKt.joinToString$default((Object[])beaconsArr, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, null, 6, null);
                return jobId;
            }
            RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "Failed to schedule beacons job | source = " + sourceStr + "; beaconsArr = " + ArraysKt.joinToString$default((Object[])beaconsArr, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, null, 6, null);
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

