/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import io.radar.sdk.Radar;
import io.radar.sdk.RadarLogger;
import io.radar.sdk.RadarState;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u0006\u0010\u0018\u001a\u00020\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/radar/sdk/RadarSensorsManager;", "Landroid/hardware/SensorEventListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "SYNC_INTERVAL_MS", "", "lastSyncTime", "pressure", "Landroid/hardware/Sensor;", "sensorManager", "Landroid/hardware/SensorManager;", "shortTermSize", "", "shortTermWindow", "", "", "userAgent", "", "onAccuracyChanged", "", "sensor", "accuracy", "onPause", "onResume", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "sdk_release"})
public final class RadarSensorsManager
implements SensorEventListener {
    @NotNull
    private SensorManager sensorManager;
    @Nullable
    private Sensor pressure;
    @NotNull
    private final Context context;
    @NotNull
    private final List<Float> shortTermWindow;
    private final int shortTermSize;
    @NotNull
    private final String userAgent;
    private long lastSyncTime;
    private final long SYNC_INTERVAL_MS;

    /*
     * WARNING - void declaration
     */
    public RadarSensorsManager(@NotNull Context context) {
        Object object;
        StringBuilder stringBuilder;
        RadarLogger radarLogger;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                this.context = context;
                this.shortTermWindow = new ArrayList();
                this.shortTermSize = 50;
                this.userAgent = "RadarSDK/Android/4.0.0";
                this.SYNC_INTERVAL_MS = 2000L;
                Object object2 = context.getSystemService("sensor");
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
                this.sensorManager = (SensorManager)object2;
                this.pressure = this.sensorManager.getDefaultSensor(6);
                RadarLogger.d$default(Radar.INSTANCE.getLogger$sdk_release(), "SensorManager initialized: " + this.sensorManager, null, null, 6, null);
                radarLogger = Radar.INSTANCE.getLogger$sdk_release();
                stringBuilder = new StringBuilder().append("Pressure sensor: ");
                object = this.pressure;
                if (object == null) break block2;
                Sensor sensor = object;
                StringBuilder stringBuilder2 = stringBuilder;
                RadarLogger radarLogger2 = radarLogger;
                boolean bl = false;
                String string = "Found - Name: " + it.getName() + ", Vendor: " + it.getVendor() + ", Power: " + it.getPower() + ", Resolution: " + it.getResolution();
                radarLogger = radarLogger2;
                stringBuilder = stringBuilder2;
                String string2 = string;
                object = string2;
                if (string2 != null) break block3;
            }
            object = "Not available on device";
        }
        RadarLogger.d$default(radarLogger, stringBuilder.append((String)object).toString(), null, null, 6, null);
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int accuracy) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    public void onSensorChanged(@NotNull SensorEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        float millibarsOfPressure = event.values[0];
        int accuracy = event.accuracy;
        long timestamp = System.currentTimeMillis();
        this.shortTermWindow.add(Float.valueOf(millibarsOfPressure));
        if (this.shortTermWindow.size() > this.shortTermSize) {
            this.shortTermWindow.remove(0);
        }
        double shortTermAverage = CollectionsKt.averageOfFloat((Iterable)this.shortTermWindow);
        if (timestamp - this.lastSyncTime >= this.SYNC_INTERVAL_MS) {
            JSONObject pressureJson = new JSONObject();
            pressureJson.put("accuracy", accuracy);
            pressureJson.put("pressure", shortTermAverage);
            pressureJson.put("absoluteAltitudeTimestamp", timestamp / (long)1000);
            RadarState.INSTANCE.setLastPressure$sdk_release(this.context, pressureJson);
            this.lastSyncTime = timestamp;
        }
    }

    public final void onResume() {
        if (this.pressure != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.pressure, 3);
        }
    }

    public final void onPause() {
        if (this.pressure != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }
}

