/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.annotation.SuppressLint;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import io.radar.sdk.util.BatteryState;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\t\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\nH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u000f\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/radar/sdk/RadarBatteryManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "powerManager", "Landroid/os/PowerManager;", "usageStatsManager", "Landroid/app/usage/UsageStatsManager;", "getAppStandbyBucket", "", "()Ljava/lang/Integer;", "getBatteryState", "Lio/radar/sdk/util/BatteryState;", "getLocationPowerSaveMode", "isDeviceIdleMode", "", "isIgnoringBatteryOptimizations", "isPowerSaveMode", "()Ljava/lang/Boolean;", "Companion", "sdk_release"})
public final class RadarBatteryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final PowerManager powerManager;
    @Nullable
    private final UsageStatsManager usageStatsManager;
    private static final int locationUnaffected = Build.VERSION.SDK_INT >= 28 ? 0 : 0;

    public RadarBatteryManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.powerManager = (PowerManager)this.context.getSystemService("power");
        this.usageStatsManager = Build.VERSION.SDK_INT >= 28 ? (UsageStatsManager)this.context.getSystemService("usagestats") : (UsageStatsManager)null;
    }

    @NotNull
    public final BatteryState getBatteryState() {
        Float batteryPct;
        Float f;
        Intent batteryStatus;
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        boolean bl = false;
        Intent intent = batteryStatus = this.context.registerReceiver(null, filter);
        int status = intent != null ? intent.getIntExtra("status", -1) : -1;
        boolean isCharging = status == 2 || status == 5;
        Intent intent2 = batteryStatus;
        if (intent2 != null) {
            Intent intent3 = intent2;
            boolean bl2 = false;
            int level = intent3.getIntExtra("level", -1);
            int scale = intent3.getIntExtra("scale", -1);
            f = Float.valueOf((float)(level * 100) / (float)scale);
        } else {
            f = null;
        }
        Float f2 = batteryPct = f;
        return new BatteryState(isCharging, f2 != null ? f2.floatValue() : 0.0f, this.isPowerSaveMode(), this.isIgnoringBatteryOptimizations(), this.getLocationPowerSaveMode(), this.isDeviceIdleMode());
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public final Integer getAppStandbyBucket() {
        UsageStatsManager usageStatsManager = this.usageStatsManager;
        return usageStatsManager != null ? Integer.valueOf(usageStatsManager.getAppStandbyBucket()) : null;
    }

    private final Boolean isPowerSaveMode() {
        if (Build.VERSION.SDK_INT >= 21) {
            PowerManager powerManager = this.powerManager;
            return powerManager != null ? Boolean.valueOf(powerManager.isPowerSaveMode()) : null;
        }
        return null;
    }

    private final int getLocationPowerSaveMode() {
        if (Build.VERSION.SDK_INT >= 28 && this.powerManager != null) {
            return this.powerManager.getLocationPowerSaveMode();
        }
        return locationUnaffected;
    }

    private final boolean isDeviceIdleMode() {
        if (Build.VERSION.SDK_INT >= 23 && this.powerManager != null) {
            return this.powerManager.isDeviceIdleMode();
        }
        return false;
    }

    private final boolean isIgnoringBatteryOptimizations() {
        if (Build.VERSION.SDK_INT >= 23 && this.powerManager != null) {
            return this.powerManager.isIgnoringBatteryOptimizations(this.context.getPackageName());
        }
        return false;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/radar/sdk/RadarBatteryManager$Companion;", "", "()V", "locationUnaffected", "", "getLocationUnaffected", "()I", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLocationUnaffected() {
            return locationUnaffected;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

