/*
 * Decompiled with CFR 0.152.
 */
package io.radar.sdk;

import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.os.ParcelUuid;
import androidx.annotation.RequiresApi;
import io.radar.sdk.model.RadarBeacon;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010J#\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0014J#\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010 \u001a\u00020\u0013J\u0010\u0010!\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020\u0013J\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010%J#\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010'J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\tH\u0002J\u0010\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020)H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/radar/sdk/RadarBeaconUtils;", "", "()V", "EDDYSTONE_SERVICE_UUID", "Landroid/os/ParcelUuid;", "kotlin.jvm.PlatformType", "HEX", "", "IBEACON_MANUFACTURER_ID", "", "beaconsForScanResults", "", "Lio/radar/sdk/model/RadarBeacon;", "scanResults", "Ljava/util/ArrayList;", "Landroid/bluetooth/le/ScanResult;", "(Ljava/util/ArrayList;)[Lio/radar/sdk/model/RadarBeacon;", "beaconsForStringArray", "arr", "", "([Ljava/lang/String;)[Lio/radar/sdk/model/RadarBeacon;", "beaconsForStringSet", "set", "", "(Ljava/util/Set;)[Lio/radar/sdk/model/RadarBeacon;", "getBeacon", "result", "scanRecord", "Landroid/bluetooth/le/ScanRecord;", "getScanFilterForBeacon", "Landroid/bluetooth/le/ScanFilter;", "beacon", "beaconUUID", "getScanFilterForBeaconUID", "beaconUID", "stringArrayForBeacons", "beacons", "([Lio/radar/sdk/model/RadarBeacon;)[Ljava/lang/String;", "stringSetForBeacons", "([Lio/radar/sdk/model/RadarBeacon;)Ljava/util/Set;", "toByteArray", "", "hex", "max", "toHex", "bytes", "sdk_release"})
@RequiresApi(value=21)
public final class RadarBeaconUtils {
    @NotNull
    public static final RadarBeaconUtils INSTANCE = new RadarBeaconUtils();
    private static final int IBEACON_MANUFACTURER_ID = 76;
    private static final ParcelUuid EDDYSTONE_SERVICE_UUID = ParcelUuid.fromString((String)"0000FEAA-0000-1000-8000-00805F9B34FB");
    @NotNull
    private static final char[] HEX;

    private RadarBeaconUtils() {
    }

    @NotNull
    public final RadarBeacon[] beaconsForScanResults(@Nullable ArrayList<ScanResult> scanResults) {
        Collection collection = scanResults;
        if (collection == null || collection.isEmpty()) {
            return new RadarBeacon[0];
        }
        List beacons = new ArrayList();
        Iterable $this$forEach$iv = scanResults;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScanResult result = (ScanResult)element$iv;
            boolean bl = false;
            Object object = result.getScanRecord();
            if (object == null) continue;
            ScanRecord scanRecord = object;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)scanRecord, (String)"scanRecord");
            RadarBeacon radarBeacon = INSTANCE.getBeacon(result, scanRecord);
            object = radarBeacon;
            if (radarBeacon == null) continue;
            Object beacon = object;
            boolean bl3 = false;
            beacons.add(beacon);
        }
        Collection $this$toTypedArray$iv = beacons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarBeacon[] radarBeaconArray = thisCollection$iv.toArray(new RadarBeacon[0]);
        Intrinsics.checkNotNull((Object)radarBeaconArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return radarBeaconArray;
    }

    @Nullable
    public final Set<String> stringSetForBeacons(@Nullable RadarBeacon[] beacons) {
        if (beacons == null) {
            return null;
        }
        Object[] arr = this.stringArrayForBeacons(beacons);
        return ArraysKt.toSet((Object[])arr);
    }

    @NotNull
    public final String[] stringArrayForBeacons(@NotNull RadarBeacon[] beacons) {
        Intrinsics.checkNotNullParameter((Object)beacons, (String)"beacons");
        List arr = new ArrayList();
        RadarBeacon[] $this$forEach$iv = beacons;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            RadarBeacon element$iv;
            RadarBeacon beacon = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = beacon.toJson().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"beacon.toJson().toString()");
            arr.add(string);
        }
        Collection $this$toTypedArray$iv = arr;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return stringArray;
    }

    @Nullable
    public final RadarBeacon[] beaconsForStringSet(@Nullable Set<String> set) {
        if (set == null) {
            return null;
        }
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] arr = stringArray;
        return this.beaconsForStringArray(arr);
    }

    @Nullable
    public final RadarBeacon[] beaconsForStringArray(@Nullable String[] arr) {
        if (arr == null) {
            return null;
        }
        List beacons = new ArrayList();
        String[] $this$forEach$iv = arr;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String str = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            RadarBeacon beacon = RadarBeacon.Companion.fromJson(new JSONObject(str));
            if (beacon == null) continue;
            beacons.add(beacon);
        }
        Collection $this$toTypedArray$iv = beacons;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        RadarBeacon[] radarBeaconArray = thisCollection$iv.toArray(new RadarBeacon[0]);
        Intrinsics.checkNotNull((Object)radarBeaconArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        return radarBeaconArray;
    }

    @Nullable
    public final ScanFilter getScanFilterForBeacon(@NotNull RadarBeacon beacon) {
        Intrinsics.checkNotNullParameter((Object)beacon, (String)"beacon");
        if (beacon.getType() == RadarBeacon.RadarBeaconType.EDDYSTONE) {
            int n;
            String uid = beacon.getUuid();
            String identifier = beacon.getMajor();
            int n2 = 0;
            byte[] byArray = new byte[2];
            ByteBuffer byteBuffer = ByteBuffer.allocate(18);
            while (n2 < 2) {
                int n3 = n2++;
                byArray[n3] = 0;
            }
            byte[] serviceData = byteBuffer.put(byArray).put(this.toByteArray(uid, 10)).put(this.toByteArray(identifier, 6)).array();
            int n4 = 0;
            byte[] byArray2 = new byte[1];
            byteBuffer = ByteBuffer.allocate(18);
            while (n4 < 1) {
                n = n4++;
                byArray2[n] = -1;
            }
            ByteBuffer byteBuffer2 = byteBuffer.put(byArray2);
            n4 = 0;
            byArray2 = new byte[1];
            byteBuffer = byteBuffer2;
            while (n4 < 1) {
                n = n4++;
                byArray2[n] = 0;
            }
            ByteBuffer byteBuffer3 = byteBuffer.put(byArray2);
            n4 = 0;
            byArray2 = new byte[16];
            byteBuffer = byteBuffer3;
            while (n4 < 16) {
                n = n4++;
                byArray2[n] = -1;
            }
            byte[] serviceDataMask = byteBuffer.put(byArray2).array();
            return new ScanFilter.Builder().setServiceUuid(EDDYSTONE_SERVICE_UUID).setServiceData(EDDYSTONE_SERVICE_UUID, serviceData, serviceDataMask).build();
        }
        if (beacon.getType() == RadarBeacon.RadarBeaconType.IBEACON) {
            int n;
            int n5;
            UUID uuid = UUID.fromString(beacon.getUuid());
            int major = Integer.parseInt(beacon.getMajor());
            int minor = Integer.parseInt(beacon.getMinor());
            int n6 = 0;
            byte[] byArray = new byte[2];
            ByteBuffer byteBuffer = ByteBuffer.allocate(23);
            while (n6 < 2) {
                n5 = n6++;
                byArray[n5] = 0;
            }
            ByteBuffer byteBuffer4 = byteBuffer.put(byArray).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).put((byte)(major / 256)).put((byte)(major % 256)).put((byte)(minor / 256)).put((byte)(minor % 256));
            n6 = 0;
            byArray = new byte[1];
            byteBuffer = byteBuffer4;
            while (n6 < 1) {
                n5 = n6++;
                byArray[n5] = 0;
            }
            byte[] manufacturerData = byteBuffer.put(byArray).array();
            int n7 = 0;
            byte[] byArray3 = new byte[2];
            byteBuffer = ByteBuffer.allocate(23);
            while (n7 < 2) {
                n = n7++;
                byArray3[n] = 0;
            }
            ByteBuffer byteBuffer5 = byteBuffer.put(byArray3);
            n7 = 0;
            byArray3 = new byte[20];
            byteBuffer = byteBuffer5;
            while (n7 < 20) {
                n = n7++;
                byArray3[n] = -1;
            }
            ByteBuffer byteBuffer6 = byteBuffer.put(byArray3);
            n7 = 0;
            byArray3 = new byte[1];
            byteBuffer = byteBuffer6;
            while (n7 < 1) {
                n = n7++;
                byArray3[n] = 0;
            }
            byte[] manufacturerDataMask = byteBuffer.put(byArray3).array();
            return new ScanFilter.Builder().setManufacturerData(76, manufacturerData, manufacturerDataMask).build();
        }
        return null;
    }

    @Nullable
    public final ScanFilter getScanFilterForBeacon(@NotNull String beaconUUID) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)beaconUUID, (String)"beaconUUID");
        String string = beaconUUID.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        UUID uuid = UUID.fromString(string);
        int n3 = 0;
        byte[] byArray = new byte[2];
        ByteBuffer byteBuffer = ByteBuffer.allocate(23);
        while (n3 < 2) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        ByteBuffer byteBuffer2 = byteBuffer.put(byArray).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
        n3 = 0;
        byArray = new byte[5];
        byteBuffer = byteBuffer2;
        while (n3 < 5) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        byte[] manufacturerData = byteBuffer.put(byArray).array();
        int n4 = 0;
        byte[] byArray2 = new byte[2];
        byteBuffer = ByteBuffer.allocate(23);
        while (n4 < 2) {
            n = n4++;
            byArray2[n] = 0;
        }
        ByteBuffer byteBuffer3 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[16];
        byteBuffer = byteBuffer3;
        while (n4 < 16) {
            n = n4++;
            byArray2[n] = -1;
        }
        ByteBuffer byteBuffer4 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[5];
        byteBuffer = byteBuffer4;
        while (n4 < 5) {
            n = n4++;
            byArray2[n] = 0;
        }
        byte[] manufacturerDataMask = byteBuffer.put(byArray2).array();
        return new ScanFilter.Builder().setManufacturerData(76, manufacturerData, manufacturerDataMask).build();
    }

    @Nullable
    public final ScanFilter getScanFilterForBeaconUID(@NotNull String beaconUID) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)beaconUID, (String)"beaconUID");
        int n3 = 0;
        byte[] byArray = new byte[2];
        ByteBuffer byteBuffer = ByteBuffer.allocate(18);
        while (n3 < 2) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        ByteBuffer byteBuffer2 = byteBuffer.put(byArray).put(this.toByteArray(beaconUID, 10));
        n3 = 0;
        byArray = new byte[6];
        byteBuffer = byteBuffer2;
        while (n3 < 6) {
            n2 = n3++;
            byArray[n2] = 0;
        }
        byte[] serviceData = byteBuffer.put(byArray).array();
        int n4 = 0;
        byte[] byArray2 = new byte[1];
        byteBuffer = ByteBuffer.allocate(18);
        while (n4 < 1) {
            n = n4++;
            byArray2[n] = -1;
        }
        ByteBuffer byteBuffer3 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[1];
        byteBuffer = byteBuffer3;
        while (n4 < 1) {
            n = n4++;
            byArray2[n] = 0;
        }
        ByteBuffer byteBuffer4 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[10];
        byteBuffer = byteBuffer4;
        while (n4 < 10) {
            n = n4++;
            byArray2[n] = -1;
        }
        ByteBuffer byteBuffer5 = byteBuffer.put(byArray2);
        n4 = 0;
        byArray2 = new byte[6];
        byteBuffer = byteBuffer5;
        while (n4 < 6) {
            n = n4++;
            byArray2[n] = 0;
        }
        byte[] serviceDataMask = byteBuffer.put(byArray2).array();
        return new ScanFilter.Builder().setServiceUuid(EDDYSTONE_SERVICE_UUID).setServiceData(EDDYSTONE_SERVICE_UUID, serviceData, serviceDataMask).build();
    }

    @Nullable
    public final RadarBeacon getBeacon(@NotNull ScanResult result, @NotNull ScanRecord scanRecord) {
        int startByte;
        boolean eddystone;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)scanRecord, (String)"scanRecord");
        byte[] bytes = scanRecord.getBytes();
        List serviceUuids = scanRecord.getServiceUuids();
        boolean bl = eddystone = serviceUuids != null && serviceUuids.contains(EDDYSTONE_SERVICE_UUID);
        if (eddystone) {
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
            String hex = this.toHex(bytes);
            int startByte2 = 26;
            String uid = StringsKt.substring((String)hex, (IntRange)RangesKt.until((int)startByte2, (int)(startByte2 + 20)));
            String identifier = StringsKt.substring((String)hex, (IntRange)RangesKt.until((int)(startByte2 + 20), (int)(startByte2 + 32)));
            return new RadarBeacon(null, null, null, null, uid, identifier, "", null, result.getRssi(), null, RadarBeacon.RadarBeaconType.EDDYSTONE, 655, null);
        }
        boolean iBeacon = false;
        for (startByte = 2; startByte <= 5; ++startByte) {
            if ((bytes[startByte + 2] & 0xFF) != 2 || (bytes[startByte + 3] & 0xFF) != 21) continue;
            iBeacon = true;
            break;
        }
        if (!iBeacon) {
            return null;
        }
        ByteBuffer buf = ByteBuffer.wrap(bytes, startByte + 4, 20);
        UUID uuid = new UUID(buf.getLong(), buf.getLong());
        String major = String.valueOf((buf.get() & 0xFF) * 256 + (buf.get() & 0xFF));
        String minor = String.valueOf((buf.get() & 0xFF) * 256 + (buf.get() & 0xFF));
        String string = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uuid.toString()");
        return new RadarBeacon(null, null, null, null, string, major, minor, null, result.getRssi(), null, RadarBeacon.RadarBeaconType.IBEACON, 655, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String toHex(byte[] bytes) {
        char[] hex = new char[2 * bytes.length];
        byte[] $this$forEachIndexed$iv = bytes;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (byte item$iv : $this$forEachIndexed$iv) {
            void byteVal;
            int n = index$iv++;
            byte by = item$iv;
            int i = n;
            boolean bl = false;
            int unsigned = 0xFF & byteVal;
            hex[2 * i] = HEX[unsigned / 16];
            hex[2 * i + 1] = HEX[unsigned % 16];
        }
        return ArraysKt.joinToString$default((char[])hex, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] toByteArray(String hex, int max) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = StringsKt.chunked((CharSequence)hex, (int)2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((byte)Integer.parseInt((String)it, CharsKt.checkRadix((int)16)));
        }
        return ArraysKt.sliceArray((byte[])CollectionsKt.toByteArray((Collection)((List)destination$iv$iv)), (IntRange)RangesKt.until((int)0, (int)max));
    }

    static {
        char[] cArray = "0123456789abcdef".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        HEX = cArray;
    }
}

