/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.source;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Iterator;
import ratpack.config.ConfigSource;
import ratpack.config.FileSystemBinding;

public class ObjectConfigSource
implements ConfigSource {
    private final String path;
    private final Object object;

    public ObjectConfigSource(String path, Object object) {
        this.path = path;
        this.object = object;
    }

    @Override
    public ObjectNode loadConfigData(ObjectMapper mapper, FileSystemBinding fileSystemBinding) throws Exception {
        String key;
        JsonNode value = mapper.valueToTree(this.object);
        ObjectNode root = mapper.createObjectNode();
        String[] keys = this.path.split("\\.");
        Iterator<String> iterator = Arrays.asList(keys).iterator();
        ObjectNode node = root;
        while (true) {
            key = iterator.next();
            if (!iterator.hasNext()) break;
            node = node.putObject(key);
        }
        node.set(key, value);
        return root;
    }
}

