/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Request;
import ratpack.path.PathBinding;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;

public class AssetHandler
implements Handler {
    private final ImmutableList<String> indexFiles;

    public AssetHandler(ImmutableList<String> indexFiles) {
        this.indexFiles = indexFiles;
    }

    @Override
    public void handle(Context context) {
        Request request = context.getRequest();
        String path = request.getPath();
        PathBinding pathBinding = context.maybeGet(PathBinding.class);
        if (pathBinding != null) {
            path = pathBinding.getPastBinding();
        }
        try {
            path = new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw ExceptionUtils.uncheck(e);
        }
        Path asset = context.file(path);
        if (asset != null) {
            this.servePath(context, asset);
        } else {
            context.clientError(404);
        }
    }

    private void servePath(final Context context, final Path file) {
        DefaultFileRenderer.readAttributes(context.getBackground(), file, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

            @Override
            public void execute(BasicFileAttributes attributes) {
                if (attributes == null) {
                    context.next();
                } else if (attributes.isRegularFile()) {
                    DefaultFileRenderer.sendFile(context, file, attributes);
                } else if (attributes.isDirectory()) {
                    AssetHandler.this.maybeSendFile(context, file, 0);
                } else {
                    context.next();
                }
            }
        });
    }

    private void maybeSendFile(final Context context, final Path file, final int i) {
        if (i == this.indexFiles.size()) {
            context.next();
        } else {
            String name = (String)this.indexFiles.get(i);
            final Path indexFile = file.resolve(name);
            DefaultFileRenderer.readAttributes(context.getBackground(), indexFile, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

                @Override
                public void execute(BasicFileAttributes attributes) {
                    if (attributes != null && attributes.isRegularFile()) {
                        String path = context.getRequest().getPath();
                        if (path.endsWith("/") || path.isEmpty()) {
                            DefaultFileRenderer.sendFile(context, indexFile, attributes);
                        } else {
                            context.redirect(AssetHandler.this.currentUriWithTrailingSlash(context));
                        }
                    } else {
                        AssetHandler.this.maybeSendFile(context, file, i + 1);
                    }
                }
            });
        }
    }

    private String currentUriWithTrailingSlash(Context context) {
        Request request = context.getRequest();
        String redirectUri = "/" + request.getPath() + "/";
        String query = request.getQuery();
        if (!query.isEmpty()) {
            redirectUri = redirectUri + "?" + query;
        }
        return redirectUri;
    }
}

