/*
 * Decompiled with CFR 0.152.
 */
package ratpack.form.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ratpack.form.Form;
import ratpack.form.UploadedFile;
import ratpack.form.internal.DefaultForm;
import ratpack.form.internal.DefaultUploadedFile;
import ratpack.handling.Context;
import ratpack.http.Request;
import ratpack.http.RequestBody;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public abstract class FormDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Form parseForm(Context context, RequestBody requestBody) throws RuntimeException {
        Request request = context.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().getName());
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, request.getUri());
        nettyRequest.headers().add("Content-Type", (Object)request.getContentType().toString());
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)nettyRequest);
        DefaultHttpContent content = new DefaultHttpContent(requestBody.getBuffer());
        decoder.offer((HttpContent)content);
        decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
        LinkedHashMap<String, ArrayList<String>> attributes = new LinkedHashMap<String, ArrayList<String>>();
        LinkedHashMap<String, ArrayList<String>> files = new LinkedHashMap<String, ArrayList<String>>();
        try {
            InterfaceHttpData data = decoder.next();
            while (data != null) {
                List<String> values;
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) {
                    values = (ArrayList<String>)attributes.get(data.getName());
                    if (values == null) {
                        values = new ArrayList<String>(1);
                        attributes.put(data.getName(), (ArrayList<String>)values);
                    }
                    try {
                        values.add(((Attribute)data).getValue());
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.uncheck(e);
                    }
                    finally {
                        data.release();
                    }
                }
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) {
                    values = (List)files.get(data.getName());
                    if (values == null) {
                        values = new ArrayList(1);
                        files.put(data.getName(), (ArrayList<String>)values);
                    }
                    try {
                        FileUpload nettyFileUpload = (FileUpload)data;
                        ByteBuf byteBuf = nettyFileUpload.getByteBuf();
                        DefaultUploadedFile fileUpload = new DefaultUploadedFile(DefaultMediaType.get(nettyFileUpload.getContentType()), byteBuf, nettyFileUpload.getFilename());
                        values.add((String)((Object)fileUpload));
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.uncheck(e);
                    }
                    finally {
                        data.release();
                    }
                }
                data = decoder.next();
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException ignore) {
        }
        finally {
            decoder.destroy();
        }
        return new DefaultForm(new ImmutableDelegatingMultiValueMap<String, String>(attributes), new ImmutableDelegatingMultiValueMap<String, UploadedFile>(files));
    }
}

