/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import ratpack.http.Headers;
import ratpack.http.HttpMethod;
import ratpack.http.MediaType;
import ratpack.http.Request;
import ratpack.http.internal.DefaultHttpMethod;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.ExceptionUtils;
import ratpack.util.MultiValueMap;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public class DefaultRequest
implements Request {
    private final Headers headers;
    private final ByteBuf content;
    private final String uri;
    private MediaType mediaType;
    private ImmutableDelegatingMultiValueMap<String, String> queryParams;
    private String query;
    private String path;
    private final HttpMethod method;
    private Set<Cookie> cookies;

    public DefaultRequest(Headers headers, String methodName, String uri, ByteBuf content) {
        this.headers = headers;
        this.method = new DefaultHttpMethod(methodName);
        this.uri = uri;
        this.content = content;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.getUri());
            this.queryParams = new ImmutableDelegatingMultiValueMap(queryStringDecoder.parameters());
        }
        return this.queryParams;
    }

    @Override
    public MediaType getContentType() {
        if (this.mediaType == null) {
            this.mediaType = DefaultMediaType.get(this.headers.get("Content-Type"));
        }
        return this.mediaType;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getQuery() {
        if (this.query == null) {
            String uri = this.getUri();
            int i = uri.indexOf("?");
            this.query = i < 0 || i == uri.length() ? "" : uri.substring(i + 1);
        }
        return this.query;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            String uri = this.getUri();
            String noSlash = uri.substring(1);
            int i = noSlash.indexOf("?");
            this.path = i < 0 ? noSlash : noSlash.substring(0, i);
        }
        return this.path;
    }

    @Override
    public String getText() {
        return this.getBuffer().toString(Charset.forName(this.getContentType().getCharset()));
    }

    @Override
    public byte[] getBytes() {
        ByteBuf buffer = this.getBuffer();
        if (buffer.hasArray()) {
            return buffer.array();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.writerIndex());
        try {
            this.writeBodyTo(baos);
        }
        catch (IOException e) {
            throw ExceptionUtils.uncheck(e);
        }
        return baos.toByteArray();
    }

    @Override
    public void writeBodyTo(OutputStream destination) throws IOException {
        ByteBuf buffer = this.getBuffer();
        buffer.resetReaderIndex();
        buffer.readBytes(destination, buffer.writerIndex());
    }

    @Override
    public InputStream getInputStream() {
        return new ByteBufInputStream(this.getBuffer());
    }

    @Override
    public ByteBuf getBuffer() {
        return this.content;
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            String header = this.headers.get("Cookie");
            this.cookies = header == null || header.length() == 0 ? Collections.emptySet() : CookieDecoder.decode((String)header);
        }
        return this.cookies;
    }

    @Override
    public String oneCookie(String name) {
        Cookie found = null;
        ArrayList<Cookie> allFound = null;
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.getName().equals(name)) continue;
            if (found == null) {
                found = cookie;
                continue;
            }
            if (allFound == null) {
                allFound = new ArrayList<Cookie>(2);
                allFound.add(found);
                continue;
            }
            allFound.add(cookie);
        }
        if (found == null) {
            return null;
        }
        if (allFound != null) {
            StringBuilder s = new StringBuilder("Multiple cookies with name '").append(name).append("': ");
            int i = 0;
            for (Cookie cookie : allFound) {
                s.append(cookie.toString());
                if (++i >= allFound.size()) continue;
                s.append(", ");
            }
            throw new IllegalStateException(s.toString());
        }
        return found.getValue();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }
}

