/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ratpack.background.Background;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.file.internal.FileHttpTransmitter;
import ratpack.http.MutableHeaders;
import ratpack.http.Response;
import ratpack.http.Status;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.IoUtils;

public class DefaultResponse
implements Response {
    private final Status status;
    private final MutableHeaders headers;
    private final ByteBuf body;
    private final FileHttpTransmitter fileHttpTransmitter;
    private final Action<? super Response> committer;
    private boolean contentTypeSet;
    private Set<Cookie> cookies;

    public DefaultResponse(Status status, MutableHeaders headers, ByteBuf body, FileHttpTransmitter fileHttpTransmitter, Action<? super Response> committer) {
        this.status = status;
        this.fileHttpTransmitter = fileHttpTransmitter;
        this.headers = new MutableHeadersWrapper(headers);
        this.body = body;
        this.committer = committer;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Response status(int code) {
        this.status.set(code);
        return this;
    }

    @Override
    public Response status(int code, String message) {
        this.status.set(code, message);
        return this;
    }

    @Override
    public ByteBuf getBody() {
        return this.body;
    }

    @Override
    public MutableHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void send() {
        this.commit();
    }

    @Override
    public Response contentType(String contentType) {
        this.headers.set("Content-Type", DefaultMediaType.utf8(contentType).toString());
        return this;
    }

    @Override
    public void send(String text) {
        if (!this.contentTypeSet) {
            this.contentType("text/plain");
        }
        this.body.writeBytes(IoUtils.utf8Bytes(text));
        this.commit();
    }

    @Override
    public void send(String contentType, String body) {
        this.contentType(contentType);
        this.send(body);
    }

    @Override
    public void send(byte[] bytes) {
        if (!this.contentTypeSet) {
            this.contentType("application/octet-stream");
        }
        this.body.writeBytes(bytes);
        this.commit();
    }

    @Override
    public void send(String contentType, byte[] bytes) {
        this.contentType(contentType).send(bytes);
    }

    @Override
    public void send(InputStream inputStream) throws IOException {
        IoUtils.writeTo(inputStream, this.body);
        this.commit();
    }

    @Override
    public void send(String contentType, InputStream inputStream) throws IOException {
        this.contentType(contentType).send(inputStream);
    }

    @Override
    public void send(String contentType, ByteBuf buffer) {
        this.contentType(contentType);
        this.send(buffer);
    }

    @Override
    public void send(ByteBuf buffer) {
        if (!this.contentTypeSet) {
            this.contentType("application/octet-stream");
        }
        this.body.writeBytes(buffer);
        this.commit();
    }

    @Override
    public void sendFile(Background background, String contentType, BasicFileAttributes attributes, Path file) {
        this.contentType(contentType);
        this.setCookieHeader();
        this.fileHttpTransmitter.transmit(background, attributes, file);
    }

    @Override
    public void sendFile(final Background background, final String contentType, final Path file) {
        DefaultFileRenderer.readAttributes(background, file, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

            @Override
            public void execute(BasicFileAttributes fileAttributes) {
                DefaultResponse.this.sendFile(background, contentType, fileAttributes, file);
            }
        });
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        return this.cookies;
    }

    @Override
    public Cookie cookie(String name, String value) {
        DefaultCookie cookie = new DefaultCookie(name, value);
        this.getCookies().add((Cookie)cookie);
        return cookie;
    }

    @Override
    public Cookie expireCookie(String name) {
        Cookie cookie = this.cookie(name, "");
        cookie.setMaxAge(0L);
        return cookie;
    }

    private void setCookieHeader() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.headers.add("Set-Cookie", ServerCookieEncoder.encode((Cookie)cookie));
            }
        }
    }

    private void commit() {
        this.setCookieHeader();
        try {
            this.committer.execute(this);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    class MutableHeadersWrapper
    implements MutableHeaders {
        private final MutableHeaders wrapped;

        MutableHeadersWrapper(MutableHeaders wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void add(String name, Object value) {
            if (name.equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.add(name, value);
        }

        @Override
        public void set(String name, Object value) {
            if (name.equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, value);
        }

        @Override
        public void setDate(String name, Date value) {
            this.wrapped.set(name, value);
        }

        @Override
        public void set(String name, Iterable<?> values) {
            if (name.equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, values);
        }

        @Override
        public void remove(String name) {
            if (name.equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = false;
            }
            this.wrapped.remove(name);
        }

        @Override
        public void clear() {
            DefaultResponse.this.contentTypeSet = false;
            this.wrapped.clear();
        }

        @Override
        public String get(String name) {
            return this.wrapped.get(name);
        }

        @Override
        public Date getDate(String name) {
            return this.wrapped.getDate(name);
        }

        @Override
        public List<String> getAll(String name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public boolean contains(String name) {
            return this.wrapped.contains(name);
        }

        @Override
        public Set<String> getNames() {
            return this.wrapped.getNames();
        }
    }
}

