/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;

public class HierarchicalRegistry
implements Registry {
    private final Registry parent;
    private final Registry child;

    public HierarchicalRegistry(Registry parent, Registry child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public <O> O get(Class<O> type) throws NotInRegistryException {
        O object = this.maybeGet(type);
        if (object == null) {
            throw new NotInRegistryException(type);
        }
        return object;
    }

    @Override
    public <O> O maybeGet(Class<O> type) {
        O object = this.child.maybeGet(type);
        if (object == null) {
            object = this.parent.maybeGet(type);
        }
        return object;
    }

    @Override
    public <O> List<O> getAll(Class<O> type) {
        List<O> childAll = this.child.getAll(type);
        List<O> parentAll = this.parent.getAll(type);
        return ImmutableList.builder().addAll(childAll).addAll(parentAll).build();
    }
}

