/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.util.concurrent.ListeningExecutorService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultClientErrorHandler;
import ratpack.error.internal.DefaultServerErrorHandler;
import ratpack.error.internal.ErrorCatchingHandler;
import ratpack.event.internal.DefaultEventController;
import ratpack.event.internal.EventController;
import ratpack.file.FileRenderer;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.DefaultFileHttpTransmitter;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.form.FormParser;
import ratpack.form.internal.MultipartFormParser;
import ratpack.form.internal.UrlEncodedFormParser;
import ratpack.handling.Handler;
import ratpack.handling.Redirector;
import ratpack.handling.direct.internal.DefaultDirectChannelAccess;
import ratpack.handling.internal.ClientErrorForwardingHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.http.MutableHeaders;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.render.CharSequenceRenderer;
import ratpack.render.internal.DefaultCharSequenceRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.Stopper;
import ratpack.server.internal.DefaultPublicAddress;
import ratpack.server.internal.InetSocketAddressBackedBindAddress;
import ratpack.util.Action;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Handler[] handlers;
    private final Handler return404;
    private final ListeningExecutorService backgroundExecutorService;
    private final ConcurrentHashMap<Channel, Action<Object>> channelSubscriptions = new ConcurrentHashMap(0);
    private Registry registry;

    public NettyHandlerAdapter(Stopper stopper, Handler handler, LaunchConfig launchConfig, ListeningExecutorService backgroundExecutorService) {
        this.backgroundExecutorService = backgroundExecutorService;
        this.handlers = new Handler[]{new ErrorCatchingHandler(handler)};
        this.return404 = new ClientErrorForwardingHandler(HttpResponseStatus.NOT_FOUND.code());
        this.registry = RegistryBuilder.builder().add(Stopper.class, stopper).add(FileSystemBinding.class, launchConfig.getBaseDir()).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, new DefaultPublicAddress(launchConfig.getPublicAddress(), launchConfig.getSSLContext() == null ? "http" : "https")).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, new DefaultClientErrorHandler()).add(ServerErrorHandler.class, new DefaultServerErrorHandler()).add(LaunchConfig.class, launchConfig).add(FileRenderer.class, new DefaultFileRenderer()).add(CharSequenceRenderer.class, new DefaultCharSequenceRenderer()).add(FormParser.class, new UrlEncodedFormParser()).add(FormParser.class, new MultipartFormParser()).build();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Action<Object> subscriber;
        if (!(msg instanceof FullHttpRequest) && (subscriber = this.channelSubscriptions.get(ctx.channel())) != null) {
            subscriber.execute(msg);
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void channelRead0(ChannelHandlerContext ctx, final FullHttpRequest nettyRequest) throws Exception {
        if (!nettyRequest.getDecoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        DefaultFullHttpResponse nettyResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        DefaultRequest request = new DefaultRequest(new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.getMethod().name(), nettyRequest.getUri(), nettyRequest.content());
        final Channel channel = ctx.channel();
        DefaultStatus responseStatus = new DefaultStatus();
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders(nettyResponse.headers());
        ByteBuf responseBody = nettyResponse.content();
        DefaultFileHttpTransmitter fileHttpTransmitter = new DefaultFileHttpTransmitter((HttpRequest)nettyRequest, (HttpResponse)nettyResponse, channel);
        DefaultEventController requestOutcomeEventController = new DefaultEventController();
        nettyRequest.content().retain();
        DefaultResponse response = new DefaultResponse(responseStatus, responseHeaders, responseBody, fileHttpTransmitter, (Action<? super Response>)new Action<Response>((FullHttpResponse)nettyResponse, responseStatus, (MutableHeaders)responseHeaders, responseBody, channel, (Request)request, requestOutcomeEventController){
            final /* synthetic */ FullHttpResponse val$nettyResponse;
            final /* synthetic */ DefaultStatus val$responseStatus;
            final /* synthetic */ MutableHeaders val$responseHeaders;
            final /* synthetic */ ByteBuf val$responseBody;
            final /* synthetic */ Channel val$channel;
            final /* synthetic */ Request val$request;
            final /* synthetic */ EventController val$requestOutcomeEventController;
            {
                this.val$nettyResponse = fullHttpResponse;
                this.val$responseStatus = defaultStatus;
                this.val$responseHeaders = mutableHeaders;
                this.val$responseBody = byteBuf;
                this.val$channel = channel;
                this.val$request = request;
                this.val$requestOutcomeEventController = eventController;
            }

            @Override
            public void execute(final Response response) {
                nettyRequest.content().release();
                this.val$nettyResponse.setStatus(this.val$responseStatus.getResponseStatus());
                this.val$responseHeaders.set("Content-Length", this.val$responseBody.writerIndex());
                boolean shouldClose = true;
                if (this.val$channel.isOpen()) {
                    if (HttpHeaders.isKeepAlive((HttpMessage)nettyRequest)) {
                        this.val$responseHeaders.set("Connection", "keep-alive");
                        shouldClose = false;
                    }
                    ChannelFuture future = this.val$channel.writeAndFlush((Object)this.val$nettyResponse);
                    future.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) {
                            DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(val$request, response, System.currentTimeMillis());
                            val$requestOutcomeEventController.fire(requestOutcome);
                        }
                    });
                    if (shouldClose) {
                        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
            }
        });
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        InetSocketAddressBackedBindAddress bindAddress = new InetSocketAddressBackedBindAddress(socketAddress);
        Action<Action<Object>> subscribeHandler = new Action<Action<Object>>(){

            @Override
            public void execute(Action<Object> thing) throws Exception {
                NettyHandlerAdapter.this.channelSubscriptions.put(channel, thing);
                channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        NettyHandlerAdapter.this.channelSubscriptions.remove(channel);
                    }
                });
            }
        };
        DefaultDirectChannelAccess directChannelAccess = new DefaultDirectChannelAccess(channel, subscribeHandler);
        EventExecutor foregroundExecutorService = ctx.executor();
        DefaultContext context = new DefaultContext(directChannelAccess, request, response, bindAddress, this.registry, this.backgroundExecutorService, (ScheduledExecutorService)foregroundExecutorService, requestOutcomeEventController.getRegistry(), this.handlers, 0, this.return404);
        context.next();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            cause.printStackTrace();
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().equals("Connection reset by peer");
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

