/*
 * Decompiled with CFR 0.152.
 */
package ratpack.event.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import ratpack.event.internal.EventController;
import ratpack.event.internal.EventRegistry;
import ratpack.util.Action;

public class DefaultEventController<T>
implements EventController<T> {
    private static final Logger LOGGER = Logger.getLogger(DefaultEventController.class.getName());
    private final List<Action<? super T>> handlers = new LinkedList<Action<? super T>>();
    private boolean fired;

    @Override
    public EventRegistry<T> getRegistry() {
        return new EventRegistry<T>(){

            @Override
            public void register(Action<? super T> eventHandler) {
                if (DefaultEventController.this.fired) {
                    LOGGER.log(Level.WARNING, "Cannot register event listener as event has been fired: " + eventHandler, new Exception());
                } else {
                    DefaultEventController.this.handlers.add(eventHandler);
                }
            }
        };
    }

    @Override
    public void fire(T payload) {
        if (this.fired) {
            LOGGER.log(Level.WARNING, "Cannot fire event with payload as event has been fired: " + payload, new Exception());
        } else {
            this.fired = true;
            for (Action<T> handler : this.handlers) {
                try {
                    handler.execute(payload);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Ignoring exception thrown by event handler when receiving payload: " + payload, e);
                }
            }
        }
    }

    public boolean isHasListeners() {
        return !this.handlers.isEmpty();
    }
}

