/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.collect.ImmutableList;
import java.util.List;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registry;
import ratpack.util.Action;

public class DefaultChain
implements Chain {
    private final List<Handler> handlers;
    private final LaunchConfig launchConfig;
    private final Registry registry;

    public DefaultChain(List<Handler> handlers, LaunchConfig launchConfig, Registry registry) {
        this.handlers = handlers;
        this.launchConfig = launchConfig;
        this.registry = registry;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public LaunchConfig getLaunchConfig() {
        return this.launchConfig;
    }

    @Override
    public Chain handler(Handler handler) {
        this.handlers.add(handler);
        return this;
    }

    @Override
    public Chain handler(String path, Handler handler) {
        return this.handler(Handlers.path(path, handler));
    }

    @Override
    public Chain prefix(String prefix, Handler handler) {
        return this.handler(Handlers.prefix(prefix, handler));
    }

    @Override
    public Chain prefix(String prefix, Action<? super Chain> action) throws Exception {
        return this.prefix(prefix, this.chain(action));
    }

    @Override
    public Chain get(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.get(), handler)));
    }

    @Override
    public Chain get(Handler handler) {
        return this.get("", handler);
    }

    @Override
    public Chain post(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.post(), handler)));
    }

    @Override
    public Chain post(Handler handler) {
        return this.post("", handler);
    }

    @Override
    public Chain put(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.put(), handler)));
    }

    @Override
    public Chain put(Handler handler) {
        return this.put("", handler);
    }

    @Override
    public Chain patch(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.patch(), handler)));
    }

    @Override
    public Chain patch(Handler handler) {
        return this.patch("", handler);
    }

    @Override
    public Chain delete(String path, Handler handler) {
        return this.handler(Handlers.path(path, Handlers.chain(Handlers.delete(), handler)));
    }

    @Override
    public Chain delete(Handler handler) {
        return this.delete("", handler);
    }

    @Override
    public Chain assets(String path, String ... indexFiles) {
        return this.handler(Handlers.assets(path, indexFiles.length == 0 ? this.launchConfig.getIndexFiles() : ImmutableList.copyOf((Object[])indexFiles)));
    }

    @Override
    public Chain register(Object service, Handler handler) {
        return this.handler(Handlers.register(service, handler));
    }

    @Override
    public Chain register(Object service, Action<? super Chain> action) throws Exception {
        return this.register(service, this.chain(action));
    }

    @Override
    public <T> Chain register(Class<? super T> type, T service, Handler handler) {
        return this.handler(Handlers.register(type, service, handler));
    }

    @Override
    public <T> Chain register(Class<? super T> type, T service, Action<? super Chain> action) throws Exception {
        return this.register(type, service, this.chain(action));
    }

    @Override
    public Chain fileSystem(String path, Handler handler) {
        return this.handler(Handlers.fileSystem(path, handler));
    }

    @Override
    public Chain fileSystem(String path, Action<? super Chain> action) throws Exception {
        return this.handler(Handlers.fileSystem(path, this.chain(action)));
    }

    @Override
    public Chain header(String headerName, String headerValue, Handler handler) {
        return this.handler(Handlers.header(headerName, headerValue, handler));
    }

    @Override
    public Handler chain(Action<? super Chain> action) throws Exception {
        return Handlers.chain(this.getLaunchConfig(), this.getRegistry(), action);
    }
}

