/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.ServerCookieEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.file.internal.FileHttpTransmitter;
import ratpack.handling.Background;
import ratpack.http.MutableHeaders;
import ratpack.http.MutableStatus;
import ratpack.http.Response;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.Action;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.IoUtils;

public class DefaultResponse
implements Response {
    private final MutableStatus status;
    private final MutableHeaders headers;
    private final FileHttpTransmitter fileHttpTransmitter;
    private final Action<? super ByteBuf> committer;
    private final ByteBufAllocator byteBufAllocator;
    private boolean contentTypeSet;
    private Set<Cookie> cookies;

    public DefaultResponse(MutableStatus status, MutableHeaders headers, FileHttpTransmitter fileHttpTransmitter, ByteBufAllocator byteBufAllocator, Action<? super ByteBuf> committer) {
        this.status = status;
        this.fileHttpTransmitter = fileHttpTransmitter;
        this.byteBufAllocator = byteBufAllocator;
        this.headers = new MutableHeadersWrapper(headers);
        this.committer = committer;
    }

    @Override
    public MutableStatus getStatus() {
        return this.status;
    }

    @Override
    public Response status(int code) {
        this.status.set(code);
        return this;
    }

    @Override
    public Response status(int code, String message) {
        this.status.set(code, message);
        return this;
    }

    @Override
    public MutableHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public void send() {
        this.commit(this.byteBufAllocator.buffer(0, 0));
    }

    @Override
    public Response contentType(String contentType) {
        this.headers.set((CharSequence)"Content-Type", DefaultMediaType.utf8(contentType).toString());
        return this;
    }

    @Override
    public void send(String text) {
        if (!this.contentTypeSet) {
            this.contentType("text/plain");
        }
        this.send(IoUtils.utf8Bytes(text));
    }

    @Override
    public void send(String contentType, String body) {
        this.contentType(contentType);
        this.send(body);
    }

    @Override
    public void send(byte[] bytes) {
        if (!this.contentTypeSet) {
            this.contentType("application/octet-stream");
        }
        this.commit(this.byteBufAllocator.buffer(bytes.length).writeBytes(bytes));
    }

    @Override
    public void send(String contentType, byte[] bytes) {
        this.contentType(contentType).send(bytes);
    }

    @Override
    public void send(InputStream inputStream) throws IOException {
        this.commit(IoUtils.writeTo(inputStream, this.byteBufAllocator.buffer()));
    }

    @Override
    public void send(String contentType, InputStream inputStream) throws IOException {
        this.contentType(contentType).send(inputStream);
    }

    @Override
    public void send(String contentType, ByteBuf buffer) {
        this.contentType(contentType);
        this.send(buffer);
    }

    @Override
    public void send(ByteBuf buffer) {
        if (!this.contentTypeSet) {
            this.contentType("application/octet-stream");
        }
        this.commit(buffer);
    }

    @Override
    public void sendFile(Background background, BasicFileAttributes attributes, Path file) {
        this.setCookieHeader();
        this.fileHttpTransmitter.transmit(background, attributes, file);
    }

    @Override
    public void sendFile(final Background background, final Path file) {
        DefaultFileRenderer.readAttributes(background, file, (Action<? super BasicFileAttributes>)new Action<BasicFileAttributes>(){

            @Override
            public void execute(BasicFileAttributes fileAttributes) {
                DefaultResponse.this.sendFile(background, fileAttributes, file);
            }
        });
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        return this.cookies;
    }

    @Override
    public Cookie cookie(String name, String value) {
        DefaultCookie cookie = new DefaultCookie(name, value);
        this.getCookies().add((Cookie)cookie);
        return cookie;
    }

    @Override
    public Cookie expireCookie(String name) {
        Cookie cookie = this.cookie(name, "");
        cookie.setMaxAge(0L);
        return cookie;
    }

    private void setCookieHeader() {
        if (this.cookies != null && !this.cookies.isEmpty()) {
            for (Cookie cookie : this.cookies) {
                this.headers.add("Set-Cookie", ServerCookieEncoder.encode((Cookie)cookie));
            }
        }
    }

    private void commit(ByteBuf byteBuf) {
        this.setCookieHeader();
        try {
            this.committer.execute((ByteBuf)byteBuf);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    class MutableHeadersWrapper
    implements MutableHeaders {
        private final MutableHeaders wrapped;

        MutableHeadersWrapper(MutableHeaders wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public void add(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && name.toString().equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.add(name, value);
        }

        @Override
        public void set(CharSequence name, Object value) {
            if (!DefaultResponse.this.contentTypeSet && name.toString().equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, value);
        }

        @Override
        public void setDate(CharSequence name, Date value) {
            this.wrapped.set(name, value);
        }

        @Override
        public void set(CharSequence name, Iterable<?> values) {
            if (!DefaultResponse.this.contentTypeSet && name.toString().equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = true;
            }
            this.wrapped.set(name, values);
        }

        @Override
        public void remove(String name) {
            if (name.equalsIgnoreCase("Content-Type")) {
                DefaultResponse.this.contentTypeSet = false;
            }
            this.wrapped.remove(name);
        }

        @Override
        public void clear() {
            DefaultResponse.this.contentTypeSet = false;
            this.wrapped.clear();
        }

        @Override
        public String get(String name) {
            return this.wrapped.get(name);
        }

        @Override
        public Date getDate(String name) {
            return this.wrapped.getDate(name);
        }

        @Override
        public List<String> getAll(String name) {
            return this.wrapped.getAll(name);
        }

        @Override
        public boolean contains(String name) {
            return this.wrapped.contains(name);
        }

        @Override
        public Set<String> getNames() {
            return this.wrapped.getNames();
        }
    }
}

