/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file;

import java.io.InputStream;
import java.util.concurrent.Executors;
import java.util.zip.Adler32;
import ratpack.file.CachingFileSystemChecksumService;
import ratpack.file.FileSystemChecksumService;
import ratpack.file.internal.DefaultFileSystemChecksumService;
import ratpack.file.internal.FileSystemChecksumServicePopulater;
import ratpack.func.Function;
import ratpack.launch.LaunchConfig;

public abstract class FileSystemChecksumServices {
    private FileSystemChecksumServices() {
    }

    public static FileSystemChecksumService service(LaunchConfig launchConfig) {
        Adler32Checksummer checksummer = new Adler32Checksummer();
        DefaultFileSystemChecksumService service = new DefaultFileSystemChecksumService(launchConfig.getBaseDir(), checksummer);
        if (launchConfig.isDevelopment()) {
            return service;
        }
        CachingFileSystemChecksumService cachingService = new CachingFileSystemChecksumService(service);
        new FileSystemChecksumServicePopulater(launchConfig.getBaseDir().getFile(), cachingService, Executors.newFixedThreadPool(5), 4).start();
        return cachingService;
    }

    private static class Adler32Checksummer
    implements Function<InputStream, String> {
        private static final int BUFFER_SIZE = 8192;

        private Adler32Checksummer() {
        }

        @Override
        public String apply(InputStream inputStream) throws Exception {
            byte[] buffer = new byte[8192];
            Adler32 checksum = new Adler32();
            int read = inputStream.read(buffer, 0, 8192);
            while (read != -1) {
                checksum.update(buffer, 0, read);
                read = inputStream.read(buffer, 0, 8192);
            }
            return Long.toHexString(checksum.getValue());
        }
    }
}

