/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.Map;
import ratpack.handling.ByContentSpec;
import ratpack.handling.Handler;

public class DefaultByContentSpec
implements ByContentSpec {
    private final Map<String, Handler> map;

    public DefaultByContentSpec(Map<String, Handler> map) {
        this.map = map;
    }

    @Override
    public ByContentSpec type(String mimeType, Handler handler) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        String trimmed = mimeType.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mimeType cannot be a blank string");
        }
        this.map.put(trimmed, handler);
        return this;
    }

    @Override
    public ByContentSpec plainText(Handler handler) {
        return this.type("text/plain", handler);
    }

    @Override
    public ByContentSpec html(Handler handler) {
        return this.type("text/html", handler);
    }

    @Override
    public ByContentSpec json(Handler handler) {
        return this.type("application/json", handler);
    }

    @Override
    public ByContentSpec xml(Handler handler) {
        return this.type("application/xml", handler);
    }
}

