/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import ratpack.func.Action;
import ratpack.http.internal.DefaultHttpUrlBuilder;
import ratpack.util.MultiValueMap;

public interface HttpUrlBuilder {
    public static HttpUrlBuilder base(URI uri) {
        return new DefaultHttpUrlBuilder(uri);
    }

    public static HttpUrlBuilder http() {
        return new DefaultHttpUrlBuilder();
    }

    public static HttpUrlBuilder https() {
        return HttpUrlBuilder.http().secure();
    }

    public HttpUrlBuilder secure();

    public HttpUrlBuilder host(String var1);

    public HttpUrlBuilder port(int var1);

    public HttpUrlBuilder path(String var1);

    public HttpUrlBuilder segment(String var1, Object ... var2);

    public HttpUrlBuilder params(String ... var1);

    default public HttpUrlBuilder params(Action<? super ImmutableMultimap.Builder<String, Object>> params) throws Exception {
        return this.params((Multimap<String, ?>)Action.with(ImmutableMultimap.builder(), params).build());
    }

    public HttpUrlBuilder params(Map<String, ?> var1);

    public HttpUrlBuilder params(Multimap<String, ?> var1);

    public HttpUrlBuilder params(MultiValueMap<String, ?> var1);

    public URI build();
}

