/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import ratpack.func.Function;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.stream.Streams;
import ratpack.util.ExceptionUtils;

public class ResponseChunks {
    private final Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory;
    private final CharSequence contentType;

    public static ResponseChunks stringChunks(Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(HttpHeaderConstants.PLAIN_TEXT_UTF8, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(contentType, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, final Charset charset, final Publisher<? extends CharSequence> publisher) {
        return new ResponseChunks(contentType, (Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>>)new Function<ByteBufAllocator, Publisher<? extends ByteBuf>>(){

            @Override
            public Publisher<? extends ByteBuf> apply(final ByteBufAllocator byteBufAllocator) throws Exception {
                return Streams.map(publisher, new Function<CharSequence, ByteBuf>(){

                    @Override
                    public ByteBuf apply(CharSequence charSequence) throws Exception {
                        return ByteBufUtil.encodeString((ByteBufAllocator)byteBufAllocator, (CharBuffer)CharBuffer.wrap(charSequence), (Charset)charset);
                    }
                });
            }
        });
    }

    public static ResponseChunks bufferChunks(CharSequence contentType, final Publisher<? extends ByteBuf> publisher) {
        return new ResponseChunks(contentType, (Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>>)new Function<ByteBufAllocator, Publisher<? extends ByteBuf>>(){

            @Override
            public Publisher<? extends ByteBuf> apply(ByteBufAllocator byteBufAllocator) throws Exception {
                return publisher;
            }
        });
    }

    private ResponseChunks(CharSequence contentType, Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory) {
        this.publisherFactory = publisherFactory;
        this.contentType = contentType;
    }

    public Publisher<? extends ByteBuf> publisher(ByteBufAllocator byteBufAllocator) {
        try {
            return this.publisherFactory.apply((ByteBufAllocator)byteBufAllocator);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    public CharSequence getContentType() {
        return this.contentType;
    }
}

