/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.internal.MimeParse;

public class ContentNegotiationHandler
implements Handler {
    private final Map<? extends CharSequence, Handler> handlers;

    public ContentNegotiationHandler(Map<? extends CharSequence, Handler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(Context context) throws Exception {
        if (this.handlers.isEmpty()) {
            context.clientError(406);
            return;
        }
        ArrayList<? extends CharSequence> types = new ArrayList<CharSequence>(this.handlers.keySet());
        CharSequence first = (CharSequence)types.get(0);
        Collections.reverse(types);
        CharSequence winner = first;
        String acceptHeader = context.getRequest().getHeaders().get("Accept");
        if (acceptHeader != null && !acceptHeader.isEmpty()) {
            winner = MimeParse.bestMatch(types, acceptHeader);
        }
        if (winner == null || winner.toString().isEmpty()) {
            context.clientError(406);
        } else {
            context.getResponse().contentType(winner);
            Handler handler = this.handlers.get(winner);
            handler.handle(context);
        }
    }
}

