/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.HttpMethod;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;

public class MethodHandler
implements Handler {
    private final String method;
    public static final Handler GET = new MethodHandler("GET");
    public static final Handler POST = new MethodHandler("POST");
    public static final Handler PUT = new MethodHandler("PUT");
    public static final Handler PATCH = new MethodHandler("PATCH");
    public static final Handler DELETE = new MethodHandler("DELETE");

    public MethodHandler(String method) {
        this.method = method.toUpperCase();
    }

    @Override
    public void handle(Context context) {
        HttpMethod requestMethod = context.getRequest().getMethod();
        if (requestMethod.name(this.method)) {
            context.next();
        } else if (requestMethod.isOptions()) {
            Response response = context.getResponse();
            response.getHeaders().add(HttpHeaderConstants.ALLOW, this.method);
            response.status(200).send();
        } else {
            context.clientError(405);
        }
    }
}

