/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.path.internal.DefaultPathBinding;

public class TokenPathBinder
implements PathBinder {
    private final ImmutableList<String> tokenNames;
    private final Pattern regex;

    protected TokenPathBinder(ImmutableList<String> tokenNames, Pattern regex) {
        this.tokenNames = tokenNames;
        this.regex = regex;
    }

    @Override
    public PathBinding bind(String path, PathBinding parentBinding) {
        Matcher matcher;
        if (parentBinding != null) {
            path = parentBinding.getPastBinding();
        }
        if ((matcher = this.regex.matcher(path)).matches()) {
            MatchResult matchResult = matcher.toMatchResult();
            String boundPath = matchResult.group(1);
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            int i = 2;
            for (String name : this.tokenNames) {
                String value;
                if ((value = matchResult.group(i++)) == null) continue;
                paramsBuilder.put((Object)name, (Object)this.decodeURIComponent(value));
            }
            return new DefaultPathBinding(path, boundPath, (ImmutableMap<String, String>)paramsBuilder.build(), parentBinding);
        }
        return null;
    }

    private String decodeURIComponent(String s) {
        String str;
        try {
            str = URLDecoder.decode(s.replaceAll("\\+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new IllegalStateException("UTF-8 decoder should always be available");
        }
        return str;
    }
}

