/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import ratpack.func.Action;
import ratpack.registry.PredicateCacheability;
import ratpack.registry.Registry;
import ratpack.util.ExceptionUtils;

public class CachingRegistry
implements Registry {
    private final Registry delegate;
    private final LoadingCache<TypeToken<?>, ? extends Optional<?>> cache = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, Optional<?>>(){

        public Optional<?> load(TypeToken<?> key) throws Exception {
            return CachingRegistry.this.delegate.maybeGet(key);
        }
    });
    private final LoadingCache<TypeToken<?>, List<?>> allCache = CacheBuilder.newBuilder().build(new CacheLoader<TypeToken<?>, List<?>>(){

        public List<?> load(TypeToken<?> key) throws Exception {
            return Lists.newArrayList(CachingRegistry.this.delegate.getAll(key));
        }
    });
    private LoadingCache<PredicateCacheability.CacheKey<?>, List<?>> predicateCache = CacheBuilder.newBuilder().build(new CacheLoader<PredicateCacheability.CacheKey<?>, List<?>>(){

        public List<?> load(PredicateCacheability.CacheKey<?> key) throws Exception {
            return Lists.newArrayList(this.getAll(key));
        }

        private <T> Iterable<? extends T> getAll(PredicateCacheability.CacheKey<T> key) {
            return CachingRegistry.this.delegate.all(key.type, key.predicate);
        }
    });

    public CachingRegistry(Registry delegate) {
        this.delegate = delegate;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        try {
            Optional o = (Optional)this.cache.get(type);
            return o;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    public <O> List<O> getAll(TypeToken<O> type) {
        try {
            List objects = (List)this.allCache.get(type);
            return objects;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    private <T> List<T> getFromPredicateCache(TypeToken<T> type, Predicate<? super T> predicate) {
        try {
            List objects = (List)this.predicateCache.get(new PredicateCacheability.CacheKey<T>(type, predicate));
            return objects;
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw ExceptionUtils.uncheck(ExceptionUtils.toException(e.getCause()));
        }
    }

    @Override
    public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            List<T> objects = this.getFromPredicateCache(type, predicate);
            if (objects.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(objects.get(0));
        }
        return this.delegate.first(type, predicate);
    }

    @Override
    public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
        if (PredicateCacheability.isCacheable(predicate)) {
            return this.getFromPredicateCache(type, predicate);
        }
        return this.delegate.all(type, predicate);
    }

    @Override
    public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
        Iterable<T> all = this.all(type, predicate);
        boolean any = false;
        for (T item : all) {
            any = true;
            action.execute(item);
        }
        return any;
    }

    public String toString() {
        return "CachingRegistry{delegate=" + this.delegate + '}';
    }
}

