/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import java.net.URI;
import java.net.URISyntaxException;
import ratpack.handling.Context;
import ratpack.http.Headers;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.server.BindAddress;
import ratpack.server.PublicAddress;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.ProtocolUtil;

public class DefaultPublicAddress
implements PublicAddress {
    private static final Splitter FORWARDED_HOST_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final URI publicAddress;
    private final String scheme;

    public DefaultPublicAddress(URI publicAddress, String scheme) {
        this.publicAddress = publicAddress;
        this.scheme = scheme;
    }

    @Override
    public URI getAddress(Context context) {
        URI currentUrl;
        if (this.publicAddress != null) {
            currentUrl = this.publicAddress;
        } else {
            int port;
            String host;
            String scheme;
            HostAndPort forwardedHostData = this.getForwardedHostData(context);
            if (forwardedHostData != null) {
                scheme = this.determineScheme(context, this.scheme);
                host = forwardedHostData.getHostText();
                port = forwardedHostData.getPortOrDefault(-1);
            } else {
                URI absoluteRequestURI = this.getAbsoluteRequestUri(context);
                if (absoluteRequestURI != null) {
                    scheme = this.determineScheme(context, absoluteRequestURI.getScheme());
                    host = absoluteRequestURI.getHost();
                    port = absoluteRequestURI.getPort();
                } else {
                    scheme = this.determineScheme(context, this.scheme);
                    HostAndPort hostData = this.getHostData(context);
                    if (hostData != null) {
                        host = hostData.getHostText();
                        port = hostData.getPortOrDefault(-1);
                    } else {
                        BindAddress bindAddress = context.getBindAddress();
                        int bindPort = bindAddress.getPort();
                        host = bindAddress.getHost();
                        port = ProtocolUtil.isDefaultPortForScheme(bindPort, this.scheme) ? -1 : bindPort;
                    }
                }
            }
            try {
                currentUrl = new URI(scheme, null, host, port, null, null, null);
            }
            catch (URISyntaxException ex) {
                throw ExceptionUtils.uncheck(ex);
            }
        }
        return currentUrl;
    }

    private URI getAbsoluteRequestUri(Context context) {
        String rawUri = Strings.nullToEmpty((String)context.getRequest().getRawUri());
        if (rawUri.isEmpty() || rawUri.startsWith("/")) {
            return null;
        }
        return URI.create(rawUri);
    }

    private HostAndPort getForwardedHostData(Context context) {
        Headers headers = context.getRequest().getHeaders();
        String forwardedHostHeader = Strings.emptyToNull((String)headers.get(HttpHeaderConstants.X_FORWARDED_HOST.toString()));
        String hostPortString = forwardedHostHeader != null ? (String)Iterables.getFirst((Iterable)FORWARDED_HOST_SPLITTER.split((CharSequence)forwardedHostHeader), null) : null;
        return hostPortString != null ? HostAndPort.fromString((String)hostPortString) : null;
    }

    private HostAndPort getHostData(Context context) {
        Headers headers = context.getRequest().getHeaders();
        String hostPortString = Strings.emptyToNull((String)headers.get(HttpHeaderConstants.HOST.toString()));
        return hostPortString != null ? HostAndPort.fromString((String)hostPortString) : null;
    }

    private String determineScheme(Context context, String defaultScheme) {
        Headers headers = context.getRequest().getHeaders();
        String forwardedSsl = headers.get(HttpHeaderConstants.X_FORWARDED_SSL.toString());
        String forwardedProto = headers.get(HttpHeaderConstants.X_FORWARDED_PROTO.toString());
        if (HttpHeaderConstants.ON.toString().equalsIgnoreCase(forwardedSsl)) {
            return "https";
        }
        return forwardedProto != null ? forwardedProto : defaultScheme;
    }
}

