/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse;

import java.util.function.Consumer;

public class ServerSentEvent {
    private String eventId;
    private String eventType;
    private String eventData;

    public static ServerSentEvent serverSentEvent(Consumer<? super Spec<?>> consumer) {
        return ServerSentEvent.serverSentEvent(null, consumer);
    }

    public static <T> ServerSentEvent serverSentEvent(final T item, Consumer<? super Spec<T>> consumer) {
        final ServerSentEvent event = new ServerSentEvent();
        consumer.accept(new Spec<T>(){

            @Override
            public T getItem() {
                return item;
            }

            @Override
            public Spec<T> id(String id) {
                event.eventId = id;
                return this;
            }

            @Override
            public Spec<T> event(String eventType) {
                event.eventType = eventType;
                return this;
            }

            @Override
            public Spec<T> data(String data) {
                event.eventData = data;
                return this;
            }
        });
        if (event.eventId == null && event.eventType == null && event.eventData == null) {
            throw new IllegalArgumentException("You must supply at least one of data, event, id");
        }
        return event;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getEventData() {
        return this.eventData;
    }

    public static interface Spec<T> {
        public T getItem();

        public Spec<T> id(String var1);

        public Spec<T> event(String var1);

        public Spec<T> data(String var1);
    }
}

