/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream;

import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.launch.LaunchConfig;
import ratpack.stream.StreamEvent;
import ratpack.stream.YieldRequest;
import ratpack.stream.internal.BufferingPublisher;
import ratpack.stream.internal.FanOutPublisher;
import ratpack.stream.internal.FlatMapPublisher;
import ratpack.stream.internal.GatedPublisher;
import ratpack.stream.internal.IterablePublisher;
import ratpack.stream.internal.MapPublisher;
import ratpack.stream.internal.MergingPublisher;
import ratpack.stream.internal.MulticastPublisher;
import ratpack.stream.internal.PeriodicPublisher;
import ratpack.stream.internal.WiretapPublisher;
import ratpack.stream.internal.YieldingPublisher;

public class Streams {
    public static <T> Publisher<T> publish(Iterable<T> iterable) {
        return new IterablePublisher<T>(iterable);
    }

    public static <T> Publisher<T> yield(Function<? super YieldRequest, T> producer) {
        return new YieldingPublisher<T>(producer);
    }

    public static <T> Publisher<T> constant(T item) {
        return Streams.yield(yieldRequest -> item);
    }

    public static <I, O> Publisher<O> map(Publisher<I> input, Function<? super I, ? extends O> function) {
        return new MapPublisher<O, I>(input, function);
    }

    public static <I, O> Publisher<O> flatMap(Publisher<I> input, Function<? super I, ? extends Promise<? extends O>> function) {
        return new FlatMapPublisher(input, function);
    }

    public static <T> Publisher<T> buffer(Publisher<T> publisher) {
        return new BufferingPublisher<T>(publisher);
    }

    public static <T> Publisher<T> gate(Publisher<T> publisher, Action<? super Runnable> valveReceiver) {
        return new GatedPublisher<T>(publisher, valveReceiver);
    }

    public static <T> Publisher<T> periodically(ScheduledExecutorService executorService, long delay, TimeUnit timeUnit, Function<Integer, T> producer) {
        return Streams.buffer(new PeriodicPublisher<T>(executorService, producer, delay, timeUnit));
    }

    public static <T> Publisher<T> periodically(LaunchConfig launchConfig, long delay, TimeUnit timeUnit, Function<Integer, T> producer) {
        return Streams.buffer(new PeriodicPublisher<T>(launchConfig.getExecController().getExecutor(), producer, delay, timeUnit));
    }

    public static <T> Publisher<T> wiretap(Publisher<T> publisher, Action<? super StreamEvent<? super T>> listener) {
        return new WiretapPublisher<T>(publisher, listener);
    }

    public static <T> Publisher<T> multicast(Publisher<T> publisher) {
        return new MulticastPublisher<T>(publisher);
    }

    public static <T> Publisher<T> fanOut(Publisher<Collection<T>> publisher) {
        return Streams.buffer(new FanOutPublisher<T>(publisher));
    }

    public static <T> Publisher<T> merge(Publisher<? extends T> ... publishers) {
        return Streams.buffer(new MergingPublisher<T>(publishers));
    }
}

