/*
 * Decompiled with CFR 0.152.
 */
package ratpack.websocket;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import ratpack.func.Function;
import ratpack.handling.Context;
import ratpack.launch.LaunchConfig;
import ratpack.websocket.AutoCloseWebSocketHandler;
import ratpack.websocket.WebSocket;
import ratpack.websocket.WebSocketConnector;
import ratpack.websocket.WebSocketHandler;
import ratpack.websocket.internal.DefaultWebSocketConnector;
import ratpack.websocket.internal.WebSocketEngine;
import ratpack.websocket.internal.WebsocketBroadcastSubscriber;

public abstract class WebSockets {
    public static <T> WebSocketConnector<T> websocket(Context context, Function<WebSocket, T> openAction) {
        return new DefaultWebSocketConnector<T>(context, openAction);
    }

    public static void websocket(Context context, WebSocketHandler<?> handler) {
        WebSocketEngine.connect(context, "/", context.get(LaunchConfig.class).getMaxContentLength(), handler);
    }

    public static void websocketBroadcast(final Context context, final Publisher<String> broadcaster) {
        WebSockets.websocket(context, new AutoCloseWebSocketHandler<AutoCloseable>(){

            @Override
            public AutoCloseable onOpen(WebSocket webSocket) throws Exception {
                WebsocketBroadcastSubscriber subscriber = new WebsocketBroadcastSubscriber(webSocket);
                context.stream(broadcaster).subscribe((Subscriber)subscriber);
                return subscriber;
            }
        });
    }
}

