/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import ratpack.exec.internal.DefaultResult;
import ratpack.util.ExceptionUtils;

public interface Result<T> {
    public static <T> Result<T> success(T value) {
        return new DefaultResult<T>(value);
    }

    public static <T> Result<T> failure(Throwable failure) {
        return new DefaultResult(failure);
    }

    public Throwable getThrowable();

    public T getValue();

    public boolean isSuccess();

    public boolean isFailure();

    default public T getValueOrThrow() throws Exception {
        if (this.isFailure()) {
            throw ExceptionUtils.toException(this.getThrowable());
        }
        return this.getValue();
    }
}

