/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ratpack.exec.ExecutionException;
import ratpack.exec.Fulfiller;
import ratpack.exec.MultiplePromiseSubscriptionException;
import ratpack.exec.Promise;
import ratpack.exec.Result;
import ratpack.exec.SuccessPromise;
import ratpack.exec.Throttle;
import ratpack.exec.internal.CachingPromise;
import ratpack.exec.internal.DefaultPromise;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.func.NoArgAction;
import ratpack.func.Predicate;
import ratpack.util.internal.InternalRatpackError;

public class DefaultSuccessPromise<T>
implements SuccessPromise<T> {
    private final Supplier<ExecutionBacking> executionSupplier;
    private final Consumer<? super Fulfiller<? super T>> fulfillment;
    private final Action<? super Throwable> errorHandler;
    private final AtomicBoolean fired = new AtomicBoolean();

    public DefaultSuccessPromise(Supplier<ExecutionBacking> executionSupplier, Consumer<? super Fulfiller<? super T>> fulfillment, Action<? super Throwable> errorHandler) {
        this.executionSupplier = executionSupplier;
        this.fulfillment = fulfillment;
        this.errorHandler = errorHandler;
    }

    @Override
    public void then(Action<? super T> then) {
        if (this.fired.compareAndSet(false, true)) {
            ExecutionBacking executionBacking = this.executionSupplier.get();
            try {
                this.doThen(new UserActionFulfiller(executionBacking, then));
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InternalRatpackError("failed to add promise resume action", e);
            }
        } else {
            throw new MultiplePromiseSubscriptionException();
        }
    }

    private void doThen(Fulfiller<? super T> fulfiller) {
        this.fulfillment.accept(fulfiller);
    }

    @Override
    public <O> DefaultPromise<O> map(Function<? super T, ? extends O> transformer) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Transform<O, O>((Fulfiller)downstream, transformer){

                @Override
                protected void onSuccess(O transformed) {
                    this.downstream.success(transformed);
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public <O> Promise<O> flatMap(Function<? super T, ? extends Promise<O>> transformer) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Transform<Promise<O>, O>((Fulfiller)downstream, transformer){

                @Override
                protected void onSuccess(Promise<O> transformed) {
                    transformed.onError(this.downstream::error).then(this.downstream::success);
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> route(final Predicate<? super T> predicate, final Action<? super T> fulfillment) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Step<T>((Fulfiller)downstream){

                @Override
                public void success(T value) {
                    boolean apply;
                    try {
                        apply = predicate.apply(value);
                    }
                    catch (Throwable e) {
                        this.error(e);
                        return;
                    }
                    if (apply) {
                        try {
                            fulfillment.execute(value);
                        }
                        catch (Throwable e) {
                            this.error(e);
                        }
                    } else {
                        this.downstream.success(value);
                    }
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> onNull(NoArgAction onNull) {
        return this.route(Objects::isNull, Action.ignoreArg(onNull));
    }

    @Override
    public <O> Promise<O> blockingMap(final Function<? super T, ? extends O> transformer) {
        return this.flatMap(new Function<T, Promise<O>>(){

            @Override
            public Promise<O> apply(T t) throws Exception {
                return ((ExecutionBacking)DefaultSuccessPromise.this.executionSupplier.get()).getExecution().getControl().blocking(() -> transformer.apply(t));
            }
        });
    }

    @Override
    public Promise<T> cache() {
        if (this.fired.compareAndSet(false, true)) {
            return new CachingPromise(this.fulfillment, this.executionSupplier, this.errorHandler);
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> onYield(Runnable onYield) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> {
                try {
                    onYield.run();
                }
                catch (Throwable e) {
                    downstream.error(e);
                    return;
                }
                this.fulfillment.accept((Fulfiller<Fulfiller>)downstream);
            });
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> defer(Action<? super Runnable> releaser) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> {
                ExecutionBacking executionBacking = this.executionSupplier.get();
                executionBacking.streamSubscribe(streamHandle -> {
                    try {
                        releaser.execute(() -> streamHandle.complete(e -> this.fulfillment.accept((Fulfiller<Fulfiller>)downstream)));
                    }
                    catch (Throwable t) {
                        downstream.error(t);
                    }
                });
            });
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> wiretap(final Action<? super Result<T>> listener) {
        if (this.fired.compareAndSet(false, true)) {
            return new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new Step<T>((Fulfiller)downstream){

                @Override
                public void success(T value) {
                    try {
                        listener.execute(Result.success(value));
                    }
                    catch (Throwable t) {
                        this.error(t);
                        return;
                    }
                    this.downstream.success(value);
                }

                @Override
                public void error(Throwable throwable) {
                    try {
                        listener.execute(Result.failure(throwable));
                    }
                    catch (Throwable t) {
                        t.addSuppressed(throwable);
                        super.error(t);
                        return;
                    }
                    super.error(throwable);
                }
            }));
        }
        throw new MultiplePromiseSubscriptionException();
    }

    @Override
    public Promise<T> throttled(Throttle throttle) {
        return throttle.throttle(new DefaultPromise(this.executionSupplier, downstream -> this.doThen(new PassThru(downstream))));
    }

    private class UserActionFulfiller
    implements Fulfiller<T> {
        private final ExecutionBacking executionBacking;
        private final Action<? super T> then;

        public UserActionFulfiller(ExecutionBacking executionBacking, Action<? super T> then) {
            this.executionBacking = executionBacking;
            this.then = then;
        }

        @Override
        public void error(Throwable throwable) {
            try {
                DefaultSuccessPromise.this.errorHandler.execute(throwable);
            }
            catch (Throwable errorHandlerThrown) {
                this.executionBacking.streamSubscribe(h -> h.complete(Action.throwException(errorHandlerThrown)));
            }
        }

        @Override
        public void success(T value) {
            try {
                this.then.execute(value);
            }
            catch (Throwable throwable) {
                this.executionBacking.streamSubscribe(h -> h.complete(Action.throwException(throwable)));
            }
        }
    }

    private abstract class Transform<I, O>
    extends Step<O> {
        private final Function<? super T, ? extends I> function;

        public Transform(Fulfiller<? super O> downstream, Function<? super T, ? extends I> function) {
            super(downstream);
            this.function = function;
        }

        @Override
        public void success(T value) {
            I transformed;
            try {
                transformed = this.function.apply(value);
            }
            catch (Throwable e) {
                this.downstream.error(e);
                return;
            }
            this.onSuccess(transformed);
        }

        protected abstract void onSuccess(I var1);
    }

    private class PassThru
    implements Fulfiller<T> {
        protected final Fulfiller<? super T> downstream;

        public PassThru(Fulfiller<? super T> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void error(Throwable throwable) {
            try {
                DefaultSuccessPromise.this.errorHandler.execute(throwable);
            }
            catch (Throwable e) {
                this.downstream.error(e);
            }
        }

        @Override
        public void success(T value) {
            this.downstream.success(value);
        }
    }

    private abstract class Step<O>
    implements Fulfiller<T> {
        protected final Fulfiller<? super O> downstream;

        public Step(Fulfiller<? super O> downstream) {
            this.downstream = downstream;
        }

        @Override
        public void error(Throwable throwable) {
            try {
                DefaultSuccessPromise.this.errorHandler.execute(throwable);
            }
            catch (Throwable e) {
                this.downstream.error(e);
            }
        }
    }
}

