/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.Fulfiller;
import ratpack.exec.OverlappingExecutionException;
import ratpack.exec.internal.ExecutionBacking;
import ratpack.func.Action;

public class SafeFulfiller<T>
implements Fulfiller<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeFulfiller.class);
    private final Fulfiller<? super T> delegate;
    private final AtomicBoolean fulfilled = new AtomicBoolean();
    private final ExecutionBacking.StreamHandle streamHandle;

    public SafeFulfiller(ExecutionBacking.StreamHandle streamHandle, Fulfiller<? super T> delegate) {
        this.streamHandle = streamHandle;
        this.delegate = delegate;
    }

    public static <T> Consumer<? super Fulfiller<? super T>> wrapping(Supplier<? extends ExecutionBacking> backingSupplier, Action<? super Fulfiller<T>> action) {
        return f -> {
            ExecutionBacking backing = (ExecutionBacking)backingSupplier.get();
            backing.streamSubscribe(streamHandle -> {
                SafeFulfiller safe = new SafeFulfiller((ExecutionBacking.StreamHandle)streamHandle, f);
                try {
                    action.execute(safe);
                }
                catch (Throwable throwable) {
                    if (!safe.fulfilled.compareAndSet(false, true)) {
                        LOGGER.error("", (Throwable)new OverlappingExecutionException("exception thrown after promise was fulfilled", throwable));
                    }
                    f.error(throwable);
                }
            });
        };
    }

    @Override
    public void error(Throwable throwable) {
        if (!this.fulfilled.compareAndSet(false, true)) {
            LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled", throwable));
            return;
        }
        this.streamHandle.complete(e -> this.delegate.error(throwable));
    }

    @Override
    public void success(T value) {
        if (!this.fulfilled.compareAndSet(false, true)) {
            LOGGER.error("", (Throwable)new OverlappingExecutionException("promise already fulfilled"));
            return;
        }
        this.streamHandle.complete(e -> this.delegate.success(value));
    }
}

