/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import ratpack.handling.Handler;

public class DescribingHandlers {
    public static void describeTo(Handler handler, StringBuilder stringBuilder) {
        Class<?> clazz = handler.getClass();
        if (clazz.isAnonymousClass()) {
            ClassPool pool = ClassPool.getDefault();
            try {
                CtClass ctClass = pool.get(clazz.getName());
                CtBehavior[] behaviors = ctClass.getDeclaredBehaviors();
                Iterable withLineNumberIterable = Iterables.filter(Arrays.asList(behaviors), input -> input.getMethodInfo().getLineNumber(0) > 0);
                LinkedList withLineNumber = Lists.newLinkedList((Iterable)withLineNumberIterable);
                Collections.sort(withLineNumber, (o1, o2) -> Integer.valueOf(o1.getMethodInfo().getLineNumber(0)).compareTo(o2.getMethodInfo().getLineNumber(0)));
                if (!withLineNumber.isEmpty()) {
                    CtBehavior method = (CtBehavior)withLineNumber.get(0);
                    int lineNumber = method.getMethodInfo().getLineNumber(0);
                    ClassFile classFile = ctClass.getClassFile();
                    String sourceFile = classFile.getSourceFile();
                    if (lineNumber != -1 && sourceFile != null) {
                        stringBuilder.append("anonymous class ").append(clazz.getName()).append(" at approximately line ").append(lineNumber).append(" of ").append(sourceFile);
                        return;
                    }
                }
            }
            catch (NotFoundException ignore) {
                // empty catch block
            }
        }
        stringBuilder.append(clazz.getName());
    }
}

