/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.MutableHeaders;
import ratpack.http.Status;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.RequestParams;
import ratpack.http.client.internal.RequestSpecBacking;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.util.ExceptionUtils;

public class DefaultHttpClient
implements HttpClient {
    private final ExecController execController;
    private final ByteBufAllocator byteBufAllocator;
    private final int maxContentLengthBytes;

    public DefaultHttpClient(ExecController execController, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        this.execController = execController;
        this.byteBufAllocator = byteBufAllocator;
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.request(uri, requestConfigurer);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, Action.join(new Post(), action));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        ExecControl execControl = this.execController.getControl();
        Execution execution = execControl.getExecution();
        EventLoop eventLoopGroup = execution.getEventLoop();
        try {
            RequestAction requestAction = new RequestAction(requestConfigurer, uri, execution, (EventLoopGroup)eventLoopGroup, this.byteBufAllocator, this.maxContentLengthBytes);
            return this.execController.getControl().promise(requestAction);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    private static ByteBuf initBufferReleaseOnExecutionClose(ByteBuf responseBuffer, Execution execution) {
        execution.onCleanup(() -> ((ByteBuf)responseBuffer).release());
        return responseBuffer;
    }

    private static String getFullPath(URI uri) {
        StringBuilder sb = new StringBuilder(uri.getRawPath());
        String query = uri.getRawQuery();
        if (query != null) {
            sb.append("?").append(query);
        }
        return sb.toString();
    }

    private static class RequestAction
    implements Action<Fulfiller<? super ReceivedResponse>> {
        final Execution execution;
        final EventLoopGroup eventLoopGroup;
        final Action<? super RequestSpec> requestConfigurer;
        final boolean finalUseSsl;
        final String host;
        final int port;
        final MutableHeaders headers;
        final RequestSpecBacking requestSpecBacking;
        final URI uri;
        private final ByteBufAllocator byteBufAllocator;
        private final int maxContentLengthBytes;
        private final RequestParams requestParams;
        private final AtomicBoolean fired = new AtomicBoolean();

        public RequestAction(Action<? super RequestSpec> requestConfigurer, URI uri, Execution execution, EventLoopGroup eventLoopGroup, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
            this.execution = execution;
            this.eventLoopGroup = eventLoopGroup;
            this.requestConfigurer = requestConfigurer;
            this.byteBufAllocator = byteBufAllocator;
            this.maxContentLengthBytes = maxContentLengthBytes;
            this.uri = uri;
            this.requestParams = new RequestParams();
            this.headers = new NettyHeadersBackedMutableHeaders((HttpHeaders)new DefaultHttpHeaders());
            this.requestSpecBacking = new RequestSpecBacking(this.headers, uri, byteBufAllocator, this.requestParams);
            try {
                requestConfigurer.execute(this.requestSpecBacking.asSpec());
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck(e);
            }
            String scheme = this.uri.getScheme();
            boolean useSsl = false;
            if (scheme.equals("https")) {
                useSsl = true;
            } else if (!scheme.equals("http")) {
                throw new IllegalArgumentException(String.format("URL '%s' is not a http url", this.uri.toString()));
            }
            this.finalUseSsl = useSsl;
            this.host = this.uri.getHost();
            this.port = this.uri.getPort() < 0 ? (useSsl ? 443 : 80) : this.uri.getPort();
        }

        @Override
        public void execute(final Fulfiller<? super ReceivedResponse> fulfiller) throws Exception {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    if (finalUseSsl) {
                        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
                        engine.setUseClientMode(true);
                        p.addLast("ssl", (ChannelHandler)new SslHandler(engine));
                    }
                    p.addLast("codec", (ChannelHandler)new HttpClientCodec());
                    p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxContentLengthBytes));
                    p.addLast("readTimeout", (ChannelHandler)new ReadTimeoutHandler(((RequestAction)this).requestParams.readTimeoutNanos, TimeUnit.NANOSECONDS));
                    p.addLast("handler", (ChannelHandler)new SimpleChannelInboundHandler<HttpObject>(false){

                        public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
                            if (msg instanceof FullHttpResponse) {
                                FullHttpResponse response = (FullHttpResponse)msg;
                                NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(response.headers());
                                String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE.toString());
                                ByteBuf responseBuffer = DefaultHttpClient.initBufferReleaseOnExecutionClose(response.content(), execution);
                                ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
                                DefaultStatus status = new DefaultStatus(response.getStatus());
                                int maxRedirects = requestSpecBacking.getMaxRedirects();
                                String locationValue = headers.get("Location");
                                URI locationUrl = null;
                                if (locationValue != null) {
                                    locationUrl = new URI(locationValue);
                                }
                                if (RequestAction.shouldRedirect(status) && maxRedirects > 0 && locationUrl != null) {
                                    Action redirectRequestConfig = Action.join(requestConfigurer, s -> {
                                        if (status.getCode() == 301 || status.getCode() == 302) {
                                            s.method("GET");
                                        }
                                        s.redirects(maxRedirects - 1);
                                    });
                                    RequestAction requestAction = new RequestAction(redirectRequestConfig, locationUrl, execution, eventLoopGroup, byteBufAllocator, maxContentLengthBytes);
                                    requestAction.execute(fulfiller);
                                } else {
                                    this.success(fulfiller, new DefaultReceivedResponse(status, headers, typedData));
                                }
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            ctx.close();
                            this.error(fulfiller, cause);
                        }
                    });
                }
            });
            ChannelFuture connectFuture = b.connect(this.host, this.port);
            connectFuture.addListener(f1 -> {
                if (connectFuture.isSuccess()) {
                    String fullPath = DefaultHttpClient.getFullPath(this.uri);
                    DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)this.requestSpecBacking.getMethod()), fullPath, this.requestSpecBacking.getBody());
                    if (this.headers.get(HttpHeaderConstants.HOST) == null) {
                        this.headers.set(HttpHeaderConstants.HOST, this.host);
                    }
                    this.headers.set(HttpHeaderConstants.CONNECTION, "close");
                    int contentLength = request.content().readableBytes();
                    if (contentLength > 0) {
                        this.headers.set(HttpHeaderConstants.CONTENT_LENGTH, Integer.toString(contentLength, 10));
                    }
                    HttpHeaders requestHeaders = request.headers();
                    for (String name : this.headers.getNames()) {
                        requestHeaders.set(name, this.headers.getAll(name));
                    }
                    ChannelFuture writeFuture = connectFuture.channel().writeAndFlush((Object)request);
                    writeFuture.addListener(f2 -> {
                        if (!writeFuture.isSuccess()) {
                            writeFuture.channel().close();
                            this.error(fulfiller, writeFuture.cause());
                        }
                    });
                } else {
                    connectFuture.channel().close();
                    this.error(fulfiller, connectFuture.cause());
                }
            });
        }

        private <T> void success(Fulfiller<? super T> fulfiller, T value) {
            if (this.fired.compareAndSet(false, true)) {
                fulfiller.success(value);
            }
        }

        private void error(Fulfiller<?> fulfiller, Throwable error) {
            if (this.fired.compareAndSet(false, true)) {
                fulfiller.error(error);
            }
        }

        private static boolean shouldRedirect(Status status) {
            int code = status.getCode();
            return code == 301 || code == 302 || code == 303 || code == 307;
        }
    }

    private static class Post
    implements Action<RequestSpec> {
        private Post() {
        }

        @Override
        public void execute(RequestSpec requestSpec) throws Exception {
            requestSpec.method("POST");
        }
    }
}

