/*
 * Decompiled with CFR 0.152.
 */
package ratpack.parse.internal;

import com.google.common.base.Predicate;
import ratpack.parse.Parse;
import ratpack.parse.Parser;

public class ParserForParsePredicate
implements Predicate<Parser<?>> {
    private final Parse<?, ?> parse;
    private final String contentType;

    public ParserForParsePredicate(Parse<?, ?> parse, String contentType) {
        this.parse = parse;
        this.contentType = contentType;
    }

    public boolean apply(Parser<?> parser) {
        return this.contentType.equalsIgnoreCase(parser.getContentType()) && parser.getOptsType().isInstance(this.parse.getOpts());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParserForParsePredicate that = (ParserForParsePredicate)o;
        return this.contentType.equalsIgnoreCase(that.contentType) && this.parse.equals(that.parse);
    }

    public int hashCode() {
        int result = this.contentType.hashCode();
        result = 31 * result + this.parse.hashCode();
        return result;
    }
}

