/*
 * Decompiled with CFR 0.152.
 */
package ratpack.sse;

import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import ratpack.func.Action;
import ratpack.sse.ServerSentEvent;
import ratpack.stream.Streams;

public class ServerSentEvents {
    private final Publisher<? extends ServerSentEvent> publisher;

    public static ServerSentEvents serverSentEvents(Publisher<? extends ServerSentEvent> publisher) {
        return new ServerSentEvents(publisher);
    }

    public static <T> ServerSentEvents serverSentEvents(Publisher<T> publisher, final Action<ServerSentEvent.Spec<T>> action) {
        return new ServerSentEvents(Streams.map(publisher, t -> {
            Consumer builder = new Consumer<ServerSentEvent.Spec<T>>(){

                @Override
                public void accept(ServerSentEvent.Spec<T> spec) {
                    try {
                        action.execute(spec);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error building server sent event", e);
                    }
                }
            };
            return ServerSentEvent.serverSentEvent(t, builder);
        }));
    }

    private ServerSentEvents(Publisher<? extends ServerSentEvent> publisher) {
        this.publisher = publisher;
    }

    public Publisher<? extends ServerSentEvent> getPublisher() {
        return this.publisher;
    }
}

