/*
 * Decompiled with CFR 0.152.
 */
package ratpack.error.internal;

import com.google.common.base.Throwables;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.internal.ErrorHandler;
import ratpack.error.internal.ErrorPageRenderer;
import ratpack.handling.Context;
import ratpack.http.Request;

public class DefaultDevelopmentErrorHandler
implements ErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDevelopmentErrorHandler.class);

    @Override
    public void error(final Context ctx, final Throwable throwable) throws Exception {
        LOGGER.error("exception thrown for request to " + ctx.getRequest().getRawUri(), throwable);
        ctx.getResponse().status(500);
        ctx.byContent(s -> s.plainText(() -> ctx.render(Throwables.getStackTraceAsString((Throwable)throwable) + "\n\nThis stacktrace error response was generated by the default development error handler.")).html(() -> new ErrorPageRenderer(){

            @Override
            protected void render() {
                this.render(ctx, "Internal Error", w -> {
                    this.messages((ErrorPageRenderer.BodyWriter)w, "Internal Error", () -> {
                        Request request = ctx.getRequest();
                        this.meta((ErrorPageRenderer.BodyWriter)w, m -> m.put((Object)"URI:", (Object)request.getRawUri()).put((Object)"Method:", (Object)request.getMethod().getName()));
                    });
                    this.stack((ErrorPageRenderer.BodyWriter)w, null, throwable);
                });
            }
        }));
    }

    @Override
    public void error(final Context ctx, int statusCode) throws Exception {
        final HttpResponseStatus status = HttpResponseStatus.valueOf((int)statusCode);
        final Request request = ctx.getRequest();
        LOGGER.error(statusCode + " client error for request to " + request.getRawUri());
        ctx.getResponse().status(statusCode);
        ctx.byContent(s -> s.plainText(() -> ctx.render("Client error " + statusCode)).html(() -> new ErrorPageRenderer(){

            @Override
            protected void render() {
                this.render(ctx, status.reasonPhrase(), w -> this.messages((ErrorPageRenderer.BodyWriter)w, "Client Error", () -> this.meta((ErrorPageRenderer.BodyWriter)w, m -> m.put((Object)"URI:", (Object)request.getRawUri()).put((Object)"Method:", (Object)request.getMethod().getName()).put((Object)"Status Code:", (Object)status.code()).put((Object)"Phrase:", (Object)status.reasonPhrase()))));
            }
        }));
    }
}

