/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.nio.file.Path;
import ratpack.file.FileSystemBinding;

public class DefaultFileSystemBinding
implements FileSystemBinding {
    private final Path binding;
    private final Path dummyNonRootBinding;

    public DefaultFileSystemBinding(Path binding) {
        if (!binding.isAbsolute()) {
            throw new IllegalArgumentException("Filesystem binding must be absolute");
        }
        this.binding = binding;
        this.dummyNonRootBinding = binding.toString().equals("/") ? binding.resolve("dummy") : null;
    }

    @Override
    public Path getFile() {
        return this.binding;
    }

    @Override
    public Path file(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.dummyNonRootBinding == null) {
            Path child = this.binding.resolve(path).normalize();
            if (child.startsWith(this.binding)) {
                return child;
            }
            return null;
        }
        Path child = this.dummyNonRootBinding.resolve(path).normalize();
        if (child.startsWith(this.dummyNonRootBinding)) {
            return this.binding.resolve(path).normalize();
        }
        return null;
    }

    @Override
    public FileSystemBinding binding(String path) {
        Path file = this.file(path);
        if (file != null) {
            return new DefaultFileSystemBinding(file);
        }
        return null;
    }

    public String toString() {
        return "FileSystemBinding[" + this.binding + ']';
    }
}

