/*
 * Decompiled with CFR 0.152.
 */
package ratpack.form.internal;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import ratpack.form.Form;
import ratpack.form.UploadedFile;
import ratpack.form.internal.DefaultForm;
import ratpack.form.internal.DefaultUploadedFile;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.RequestOutcome;
import ratpack.http.MediaType;
import ratpack.http.Request;
import ratpack.http.TypedData;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.util.ExceptionUtils;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public abstract class FormDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Form parseForm(Context context, TypedData requestBody) throws RuntimeException {
        Request request = context.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().getName());
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, method, request.getUri());
        nettyRequest.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)request.getBody().getContentType().toString());
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpRequest)nettyRequest);
        DefaultHttpContent content = new DefaultHttpContent(requestBody.getBuffer());
        decoder.offer((HttpContent)content);
        decoder.offer((HttpContent)LastHttpContent.EMPTY_LAST_CONTENT);
        LinkedHashMap<String, ArrayList<String>> attributes = new LinkedHashMap<String, ArrayList<String>>();
        LinkedHashMap<String, ArrayList<String>> files = new LinkedHashMap<String, ArrayList<String>>();
        try {
            InterfaceHttpData data = decoder.next();
            while (data != null) {
                List<String> values;
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.Attribute)) {
                    values = (ArrayList<String>)attributes.get(data.getName());
                    if (values == null) {
                        values = new ArrayList<String>(1);
                        attributes.put(data.getName(), (ArrayList<String>)values);
                    }
                    try {
                        values.add(((Attribute)data).getValue());
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.uncheck(e);
                    }
                    finally {
                        data.release();
                    }
                }
                if (data.getHttpDataType().equals((Object)InterfaceHttpData.HttpDataType.FileUpload)) {
                    values = (List)files.get(data.getName());
                    if (values == null) {
                        values = new ArrayList(1);
                        files.put(data.getName(), (ArrayList<String>)values);
                    }
                    try {
                        Charset charset;
                        FileUpload nettyFileUpload = (FileUpload)data;
                        final ByteBuf byteBuf = nettyFileUpload.getByteBuf();
                        byteBuf.retain();
                        context.onClose((Action<? super RequestOutcome>)new Action<RequestOutcome>(){

                            @Override
                            public void execute(RequestOutcome thing) throws Exception {
                                byteBuf.release();
                            }
                        });
                        String rawContentType = nettyFileUpload.getContentType();
                        MediaType contentType = rawContentType == null ? null : ((charset = nettyFileUpload.getCharset()) == null ? DefaultMediaType.get(rawContentType) : DefaultMediaType.get(rawContentType + ";charset=" + charset));
                        DefaultUploadedFile fileUpload = new DefaultUploadedFile(new ByteBufBackedTypedData(byteBuf, contentType), nettyFileUpload.getFilename());
                        values.add((String)((Object)fileUpload));
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.uncheck(e);
                    }
                    finally {
                        data.release();
                    }
                }
                data = decoder.next();
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException ignore) {
        }
        finally {
            decoder.destroy();
        }
        return new DefaultForm(new ImmutableDelegatingMultiValueMap<String, String>(attributes), new ImmutableDelegatingMultiValueMap<String, UploadedFile>(files));
    }
}

