/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import java.util.Objects;
import ratpack.util.ExceptionUtils;

@FunctionalInterface
public interface Function<I, O> {
    public O apply(I var1) throws Exception;

    default public <T> Function<I, T> andThen(Function<? super O, ? extends T> after) throws Exception {
        Objects.requireNonNull(after);
        return i -> {
            O apply = this.apply(i);
            return after.apply((O)apply);
        };
    }

    default public <T> Function<T, O> compose(Function<? super T, ? extends I> before) throws Exception {
        Objects.requireNonNull(before);
        return t -> this.apply(before.apply((Object)t));
    }

    default public java.util.function.Function<I, O> toFunction() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw ExceptionUtils.uncheck(e);
            }
        };
    }

    public static <I, O> Function<I, O> from(java.util.function.Function<I, O> function) {
        Objects.requireNonNull(function);
        return function::apply;
    }
}

