/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling.internal;

import java.util.Map;
import ratpack.func.NoArgAction;
import ratpack.handling.ByContentSpec;

public class DefaultByContentSpec
implements ByContentSpec {
    private final Map<String, NoArgAction> map;

    public DefaultByContentSpec(Map<String, NoArgAction> map) {
        this.map = map;
    }

    @Override
    public ByContentSpec type(String mimeType, NoArgAction handler) {
        if (mimeType == null) {
            throw new IllegalArgumentException("mimeType cannot be null");
        }
        String trimmed = mimeType.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mimeType cannot be a blank string");
        }
        this.map.put(trimmed, handler);
        return this;
    }

    @Override
    public ByContentSpec plainText(NoArgAction handler) {
        return this.type("text/plain", handler);
    }

    @Override
    public ByContentSpec html(NoArgAction handler) {
        return this.type("text/html", handler);
    }

    @Override
    public ByContentSpec json(NoArgAction handler) {
        return this.type("application/json", handler);
    }

    @Override
    public ByContentSpec xml(NoArgAction handler) {
        return this.type("application/xml", handler);
    }
}

