/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import ratpack.func.Function;
import ratpack.handling.Context;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.render.Renderable;
import ratpack.stream.Streams;
import ratpack.util.ExceptionUtils;

public class ResponseChunks
implements Renderable {
    private final Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory;
    private final CharSequence contentType;

    public static ResponseChunks stringChunks(Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(HttpHeaderConstants.PLAIN_TEXT_UTF8, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, Publisher<? extends CharSequence> publisher) {
        return ResponseChunks.stringChunks(contentType, CharsetUtil.UTF_8, publisher);
    }

    public static ResponseChunks stringChunks(CharSequence contentType, Charset charset, Publisher<? extends CharSequence> publisher) {
        return new ResponseChunks(contentType, allocator -> Streams.map(publisher, charSequence -> ByteBufUtil.encodeString((ByteBufAllocator)allocator, (CharBuffer)CharBuffer.wrap(charSequence), (Charset)charset)));
    }

    public static ResponseChunks bufferChunks(CharSequence contentType, Publisher<? extends ByteBuf> publisher) {
        return new ResponseChunks(contentType, byteBufAllocator -> publisher);
    }

    private ResponseChunks(CharSequence contentType, Function<? super ByteBufAllocator, ? extends Publisher<? extends ByteBuf>> publisherFactory) {
        this.publisherFactory = publisherFactory;
        this.contentType = contentType;
    }

    public Publisher<? extends ByteBuf> publisher(ByteBufAllocator byteBufAllocator) {
        return ExceptionUtils.uncheck(() -> this.publisherFactory.apply((ByteBufAllocator)byteBufAllocator));
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    @Override
    public void render(Context context) throws Exception {
        Response response = context.getResponse();
        response.getHeaders().add(HttpHeaderConstants.TRANSFER_ENCODING, HttpHeaderConstants.CHUNKED);
        response.getHeaders().set(HttpHeaderConstants.CONTENT_TYPE, this.getContentType());
        Publisher<? extends ByteBuf> publisher = this.publisher(context.getLaunchConfig().getBufferAllocator());
        response.sendStream(publisher);
    }
}

