/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBufAllocator;
import java.net.URI;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.ContentAggregatingRequestAction;
import ratpack.http.client.internal.ContentStreamingRequestAction;
import ratpack.util.ExceptionUtils;

public class DefaultHttpClient
implements HttpClient {
    private final ExecController execController;
    private final ByteBufAllocator byteBufAllocator;
    private final int maxContentLengthBytes;

    public DefaultHttpClient(ExecController execController, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        this.execController = execController;
        this.byteBufAllocator = byteBufAllocator;
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.request(uri, requestConfigurer);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, Action.join(new Post(), action));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        ExecControl execControl = this.execController.getControl();
        Execution execution = execControl.getExecution();
        try {
            ContentAggregatingRequestAction requestAction = new ContentAggregatingRequestAction(requestConfigurer, uri, execution, this.byteBufAllocator, this.maxContentLengthBytes);
            return this.execController.getControl().promise(requestAction);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        ExecControl execControl = this.execController.getControl();
        Execution execution = execControl.getExecution();
        try {
            ContentStreamingRequestAction requestAction = new ContentStreamingRequestAction(requestConfigurer, uri, execution, this.byteBufAllocator);
            return this.execController.getControl().promise(requestAction);
        }
        catch (Exception e) {
            throw ExceptionUtils.uncheck(e);
        }
    }

    private static class Post
    implements Action<RequestSpec> {
        private Post() {
        }

        @Override
        public void execute(RequestSpec requestSpec) throws Exception {
            requestSpec.method("POST");
        }
    }
}

