/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ratpack.func.NoArgAction;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.internal.MimeParse;

public class ContentNegotiationHandler
implements Handler {
    private final Map<? extends CharSequence, NoArgAction> handlers;

    public ContentNegotiationHandler(Map<? extends CharSequence, NoArgAction> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(Context context) throws Exception {
        if (this.handlers.isEmpty()) {
            context.clientError(406);
            return;
        }
        ArrayList<? extends CharSequence> types = new ArrayList<CharSequence>(this.handlers.keySet());
        CharSequence first = (CharSequence)types.get(0);
        Collections.reverse(types);
        CharSequence winner = first;
        String acceptHeader = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (acceptHeader != null && !acceptHeader.isEmpty()) {
            winner = MimeParse.bestMatch(types, acceptHeader);
        }
        if (winner == null || winner.toString().isEmpty()) {
            context.clientError(406);
        } else {
            context.getResponse().contentType(winner);
            NoArgAction handler = this.handlers.get(winner);
            handler.execute();
        }
    }
}

