/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.path.PathBinder;
import ratpack.path.PathBinding;
import ratpack.registry.Registry;
import ratpack.util.Types;

public class PathHandler
implements Handler {
    private static final TypeToken<PathBinding> TYPE = TypeToken.of(PathBinding.class);
    private final PathBinder binding;
    private final Handler handler;

    public PathHandler(PathBinder binding, Handler handler) {
        this.binding = binding;
        this.handler = handler;
    }

    @Override
    public void handle(Context context) {
        PathBinding childBinding = this.binding.bind(context.getRequest().getPath(), context.maybeGet(PathBinding.class).orElse(null));
        if (childBinding != null) {
            context.insert(new PathBindingRegistry(childBinding), this.handler);
        } else {
            context.next();
        }
    }

    private static class PathBindingRegistry
    implements Registry {
        private final PathBinding pathBinding;
        private final Optional<PathBinding> pathBindingOptional;

        public PathBindingRegistry(PathBinding pathBinding) {
            this.pathBinding = pathBinding;
            this.pathBindingOptional = Optional.of(pathBinding);
        }

        private <O> Set<? extends O> asSet() {
            return (Set)Types.cast(Collections.singleton(this.pathBinding));
        }

        @Override
        public <O> Optional<O> maybeGet(Class<O> type) {
            return PathBinding.class.isAssignableFrom(type) ? (Optional)Types.cast(this.pathBindingOptional) : Optional.empty();
        }

        @Override
        public <O> Optional<O> maybeGet(TypeToken<O> type) {
            return TYPE.isAssignableFrom(type) ? (Optional)Types.cast(this.pathBindingOptional) : Optional.empty();
        }

        public <O> Set<? extends O> getAll(TypeToken<O> type) {
            return TYPE.isAssignableFrom(type) ? this.asSet() : Collections.emptySet();
        }

        public <O> Set<? extends O> getAll(Class<O> type) {
            return PathBinding.class.isAssignableFrom(type) ? this.asSet() : Collections.emptySet();
        }

        @Override
        public <T> Optional<T> first(TypeToken<T> type, Predicate<? super T> predicate) {
            if (TYPE.isAssignableFrom(type) && predicate.apply(Types.cast(this.pathBinding))) {
                return (Optional)Types.cast(this.pathBindingOptional);
            }
            return Optional.empty();
        }

        @Override
        public <T> Iterable<? extends T> all(TypeToken<T> type, Predicate<? super T> predicate) {
            return this.first(type, predicate).map(Collections::singleton).orElseGet(Collections::emptySet);
        }

        @Override
        public <T> boolean each(TypeToken<T> type, Predicate<? super T> predicate, Action<? super T> action) throws Exception {
            Optional<T> first = this.first(type, predicate);
            if (first.isPresent()) {
                action.execute(first.get());
                return true;
            }
            return false;
        }
    }
}

