/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.function.Supplier;
import ratpack.registry.Registry;
import ratpack.registry.RegistryBuilder;
import ratpack.registry.internal.CachingRegistry;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.registry.internal.SingleEntryRegistry;

public class DefaultRegistryBuilder
implements RegistryBuilder {
    private final ImmutableList.Builder<RegistryEntry<?>> builder = ImmutableList.builder();
    private int size;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <O> RegistryBuilder add(TypeToken<? super O> type, O object) {
        this.builder.add(new DefaultRegistryEntry<O>(type, object));
        ++this.size;
        return this;
    }

    @Override
    public <O> RegistryBuilder addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.builder.add(new LazyRegistryEntry<O>(type, supplier));
        ++this.size;
        return this;
    }

    @Override
    public Registry build() {
        ImmutableList entries = this.builder.build();
        if (entries.size() == 1) {
            return new SingleEntryRegistry((RegistryEntry)entries.get(0));
        }
        return new CachingRegistry(new MultiEntryRegistry((List<? extends RegistryEntry<?>>)entries));
    }
}

