/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.error.internal.DefaultDevelopmentErrorHandler;
import ratpack.error.internal.DefaultProductionErrorHandler;
import ratpack.error.internal.ErrorHandler;
import ratpack.event.internal.DefaultEventController;
import ratpack.exec.ExecControl;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.file.internal.ActivationBackedMimeTypes;
import ratpack.file.internal.DefaultFileRenderer;
import ratpack.file.internal.ShouldCompressPredicate;
import ratpack.form.internal.FormParser;
import ratpack.func.Action;
import ratpack.func.Pair;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.handling.Redirector;
import ratpack.handling.RequestOutcome;
import ratpack.handling.direct.internal.DefaultDirectChannelAccess;
import ratpack.handling.internal.ChainHandler;
import ratpack.handling.internal.DefaultContext;
import ratpack.handling.internal.DefaultRedirector;
import ratpack.handling.internal.DescribingHandler;
import ratpack.handling.internal.DescribingHandlers;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClients;
import ratpack.http.internal.DefaultRequest;
import ratpack.http.internal.DefaultResponse;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.http.internal.NettyHeadersBackedMutableHeaders;
import ratpack.launch.LaunchConfig;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.render.internal.CharSequenceRenderer;
import ratpack.render.internal.DefaultRenderController;
import ratpack.render.internal.PromiseRenderer;
import ratpack.render.internal.PublisherRenderer;
import ratpack.render.internal.RenderableRenderer;
import ratpack.server.PublicAddress;
import ratpack.server.Stopper;
import ratpack.server.internal.DefaultPublicAddress;
import ratpack.server.internal.DefaultResponseTransmitter;

@ChannelHandler.Sharable
public class NettyHandlerAdapter
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final AttributeKey<DefaultResponseTransmitter> RESPONSE_TRANSMITTER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)DefaultResponseTransmitter.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyHandlerAdapter.class);
    private final Handler[] handlers;
    private final ConcurrentHashMap<Channel, Action<Object>> channelSubscriptions = new ConcurrentHashMap(0);
    private final DefaultContext.ApplicationConstants applicationConstants;
    private final ExecController execController;
    private final LaunchConfig launchConfig;
    private final Predicate<Pair<Long, String>> shouldCompress;
    private Registry registry;
    private final boolean addResponseTimeHeader;
    private final ExecControl execControl;

    public NettyHandlerAdapter(Stopper stopper, Handler handler, LaunchConfig launchConfig) throws Exception {
        super(false);
        this.handlers = ChainHandler.unpack(handler);
        this.launchConfig = launchConfig;
        this.registry = NettyHandlerAdapter.buildBaseRegistry(stopper, launchConfig);
        this.addResponseTimeHeader = launchConfig.isTimeResponses();
        this.applicationConstants = new DefaultContext.ApplicationConstants(launchConfig, new DefaultRenderController(), Handlers.notFound());
        this.execController = launchConfig.getExecController();
        this.execControl = this.execController.getControl();
        if (launchConfig.isCompressResponses()) {
            ImmutableSet<String> blacklist = launchConfig.getCompressionMimeTypeBlackList();
            this.shouldCompress = new ShouldCompressPredicate(launchConfig.getCompressionMinSize(), launchConfig.getCompressionMimeTypeWhiteList(), blacklist.isEmpty() ? ActivationBackedMimeTypes.getDefaultExcludedMimeTypes() : blacklist);
        } else {
            this.shouldCompress = Predicates.alwaysFalse();
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object msg) throws Exception {
        Action<Object> subscriber;
        if (!(msg instanceof FullHttpRequest) && (subscriber = this.channelSubscriptions.get(channelHandlerContext.channel())) != null) {
            subscriber.execute(msg);
            return;
        }
        super.channelRead(channelHandlerContext, msg);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest nettyRequest) throws Exception {
        if (!nettyRequest.decoderResult().isSuccess()) {
            NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            nettyRequest.release();
            return;
        }
        long startTime = this.addResponseTimeHeader ? System.nanoTime() : 0L;
        Channel channel = ctx.channel();
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
        InetSocketAddress socketAddress = (InetSocketAddress)channel.localAddress();
        DefaultRequest request = new DefaultRequest(new NettyHeadersBackedHeaders(nettyRequest.headers()), nettyRequest.method(), nettyRequest.uri(), remoteAddress, socketAddress, nettyRequest.content());
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders(false);
        NettyHeadersBackedMutableHeaders responseHeaders = new NettyHeadersBackedMutableHeaders((HttpHeaders)nettyHeaders);
        DefaultEventController<RequestOutcome> requestOutcomeEventController = new DefaultEventController<RequestOutcome>();
        AtomicBoolean transmitted = new AtomicBoolean(false);
        DefaultResponseTransmitter responseTransmitter = new DefaultResponseTransmitter(transmitted, this.execControl, channel, nettyRequest, request, (HttpHeaders)nettyHeaders, requestOutcomeEventController, this.launchConfig.isCompressResponses(), this.shouldCompress, startTime);
        DefaultResponse response = new DefaultResponse(this.execControl, responseHeaders, ctx.alloc(), responseTransmitter);
        ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).set((Object)responseTransmitter);
        Action<Action<Object>> subscribeHandler = thing -> {
            transmitted.set(true);
            this.channelSubscriptions.put(channel, (Action<Object>)thing);
            channel.closeFuture().addListener(future -> this.channelSubscriptions.remove(channel));
        };
        DefaultDirectChannelAccess directChannelAccess = new DefaultDirectChannelAccess(channel, subscribeHandler);
        DefaultContext.RequestConstants requestConstants = new DefaultContext.RequestConstants(this.applicationConstants, request, response, directChannelAccess, requestOutcomeEventController.getRegistry());
        DefaultContext.start(channel.eventLoop(), this.execController.getControl(), requestConstants, this.registry, this.handlers, execution -> {
            if (!transmitted.get()) {
                Handler lastHandler = requestConstants.handler;
                StringBuilder description = new StringBuilder();
                description.append("No response sent for ").append(request.getMethod().getName()).append(" request to ").append(request.getUri()).append(" (last handler: ");
                if (lastHandler instanceof DescribingHandler) {
                    ((DescribingHandler)lastHandler).describeTo(description);
                } else {
                    DescribingHandlers.describeTo(lastHandler, description);
                }
                description.append(")");
                String message = description.toString();
                LOGGER.warn(message);
                response.status(500);
                if (this.launchConfig.isDevelopment()) {
                    response.send(message);
                } else {
                    response.send();
                }
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.isIgnorableException(cause)) {
            LOGGER.error("", cause);
            if (ctx.channel().isActive()) {
                NettyHandlerAdapter.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        ((DefaultResponseTransmitter)ctx.attr(RESPONSE_TRANSMITTER_ATTRIBUTE_KEY).get()).writabilityChanged();
    }

    private boolean isIgnorableException(Throwable throwable) {
        return throwable instanceof IOException && throwable.getMessage().equals("Connection reset by peer");
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set(HttpHeaderConstants.CONTENT_TYPE, (Object)HttpHeaderConstants.PLAIN_TEXT_UTF8);
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static Registry buildBaseRegistry(Stopper stopper, LaunchConfig launchConfig) throws Exception {
        ErrorHandler errorHandler = launchConfig.isDevelopment() ? new DefaultDevelopmentErrorHandler() : new DefaultProductionErrorHandler();
        RegistrySpec registryBuilder = Registries.registry().add(Stopper.class, (Object)stopper).add(MimeTypes.class, new ActivationBackedMimeTypes()).add(PublicAddress.class, new DefaultPublicAddress(launchConfig.getPublicAddress(), launchConfig.getSSLContext() == null ? "http" : "https")).add(Redirector.class, new DefaultRedirector()).add(ClientErrorHandler.class, errorHandler).add(ServerErrorHandler.class, errorHandler).add(LaunchConfig.class, launchConfig).with(new DefaultFileRenderer().register()).with(new PromiseRenderer().register()).with(new PublisherRenderer().register()).with(new RenderableRenderer().register()).with(new CharSequenceRenderer().register()).add(FormParser.class, FormParser.multiPart()).add(FormParser.class, FormParser.urlEncoded()).add(HttpClient.class, HttpClients.httpClient(launchConfig));
        if (launchConfig.isHasBaseDir()) {
            registryBuilder.add(FileSystemBinding.class, launchConfig.getBaseDir());
        }
        Registry foundationRegistry = registryBuilder.build();
        Registry defaultRegistry = launchConfig.getDefaultRegistry();
        return defaultRegistry != null ? foundationRegistry.join(defaultRegistry) : foundationRegistry;
    }
}

